/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaListener;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaExecutionContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIteratorGuts;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationController;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class GFIteratorGutsMT_
extends GFIteratorGuts {
    private static final GFApplyLambdaCallback CALLBACK_NOP = new GFApplyLambdaCallback(null, null, null, null){

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.PARALLEL;
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            return OlapSetFactory.empty();
        }
    };
    private final int prefetchMaxCount;
    private final int threadCount;
    private final int batchSize;
    private final ExecutorService pool;
    private final GFParallelLambdaContext pContext;
    private boolean setIteratorDone;
    private int setIteratorTupleOrdinal;
    @Nullable
    private volatile Prefetch prefetch;
    private volatile boolean shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFIteratorGutsMT_(GFContext contextForked, GFTupleEvaluator evaluator, GFNode debuggerNode, @Nullable GFApplyLambdaListener debugger, boolean nonEmptyFunction, boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFNode setN, @Nullable GFNode lambdaN, OlapTupleSet set, OlapIterator<OlapTuple> setIterator, long setFastEstimatedSize, int limit, int prefetchMaxCount, int threadCount, int batchSize) {
        super(contextForked, evaluator, debuggerNode, debugger, nonEmptyFunction, markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args, setN, lambdaN, set, setIterator, setFastEstimatedSize, limit);
        this.prefetchMaxCount = prefetchMaxCount;
        this.threadCount = threadCount;
        this.batchSize = batchSize;
        this.setIteratorDone = false;
        this.setIteratorTupleOrdinal = 0;
        this.prefetch = null;
        this.shutdown = false;
        OlapMdxStatementExecutionContext statementContext = contextForked.getStatementExecutionContext();
        OlapSetEvaluationController controller = statementContext.getSetEvaluationController();
        OlapStack<OlapSetDeclaration> fork = controller.forkForParallelLambdaProcessing();
        this.pContext = new GFParallelLambdaContext(fork, contextForked, evaluator, null, threadCount, this.applyLambdaNode, set, setFastEstimatedSize, CALLBACK_NOP);
        this.pool = Executors.newFixedThreadPool(this.threadCount);
        try {
            ((ThreadPoolExecutor)this.pool).prestartAllCoreThreads();
        }
        finally {
            statementContext.registerHousekeeper(this::shutdownNow);
        }
    }

    private void shutdownNow() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s parallel iterator housekeeping".formatted(this.pContext.getFunctionName()));
        this.pool.shutdownNow();
    }

    @Override
    protected void onSafeNextCompleted() {
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s parallel iterator on-safe-next completed".formatted(this.pContext.getFunctionName()));
        this.shutdownNow();
    }

    @Override
    @Nullable
    protected OlapTuple doSafeNext() {
        while (true) {
            OlapTuple tuple;
            if (this.prefetch == null) {
                this.prefetch();
                if (this.prefetch == null) {
                    this.shutdownNow();
                    return null;
                }
            }
            if ((tuple = this.prefetch.removeFirst()) != null) {
                return tuple;
            }
            if (this.prefetch.batchCount == -1) {
                throw new RuntimeException("internal error : unexpected prefetch.batchCount " + this.prefetch.batchCount);
            }
            this.setIteratorTupleOrdinal = this.prefetch.iTupleOrdinal;
            this.setIteratorDone = this.prefetch.setIterationDone;
            this.prefetch = null;
            if (!this.pContext.isCancelling()) continue;
            this.prefetch = null;
            this.setIteratorDone = true;
        }
    }

    private void prefetch() {
        if (this.pContext.isCancelling() || this.setIteratorDone || this.shutdown) {
            this.prefetch = null;
            this.setIteratorDone = true;
            return;
        }
        if (this.prefetch != null) {
            throw new RuntimeException("internal error : unexpected prefetch");
        }
        this.prefetch = new Prefetch();
        this.pool.submit(() -> {
            OlapTuple iTuple;
            int prefetchedCount = 0;
            int batchCount = 0;
            int iTupleOrdinal = this.setIteratorTupleOrdinal;
            Batch batch = new Batch(batchCount, iTupleOrdinal);
            while ((iTuple = (OlapTuple)this.setIterator.next()) != null) {
                if (this.shutdown) {
                    return;
                }
                ++iTupleOrdinal;
                batch.tuples.add(iTuple);
                if (batch.tuples.size() >= this.batchSize) {
                    this.pool.submit(new PrefetchBatchTask(this.pContext, this.prefetch, batch, this));
                    batch = new Batch(++batchCount, iTupleOrdinal);
                }
                if (++prefetchedCount < this.prefetchMaxCount) continue;
            }
            if (this.shutdown) {
                return;
            }
            if (!batch.tuples.isEmpty()) {
                this.pool.submit(new PrefetchBatchTask(this.pContext, this.prefetch, batch, this));
                ++batchCount;
            }
            this.pool.submit(new PrefetchDoneTask(this.pContext, this.prefetch, batchCount, iTupleOrdinal, iTuple == null));
        });
    }

    static class Prefetch {
        private final BlockingQueue<BatchExecuted> queue = new LinkedBlockingQueue<BatchExecuted>();
        private final SortedSet<BatchExecuted> executedBatches = new TreeSet<BatchExecuted>(Comparator.comparingInt(o -> o.index));
        private BatchExecuted currentBatch;
        volatile int batchCount = -1;
        volatile int iTupleOrdinal = -1;
        volatile boolean setIterationDone = false;

        Prefetch() {
        }

        @Nullable
        OlapTuple removeFirst() {
            do {
                OlapTuple tuple;
                if (this.currentBatch != null && (tuple = this.currentBatch.removeFirst()) != null) {
                    return tuple;
                }
                int requiredBatchIndex = this.currentBatch == null ? 0 : this.currentBatch.index + 1;
                this.currentBatch = this.retrieveBatch(requiredBatchIndex);
            } while (this.currentBatch != null);
            return null;
        }

        @Nullable
        BatchExecuted retrieveBatch(int batchIndex) {
            while (true) {
                if (!this.executedBatches.isEmpty()) {
                    BatchExecuted e = this.executedBatches.getFirst();
                    if (e.index == batchIndex) {
                        this.executedBatches.removeFirst();
                        return e;
                    }
                }
                if (this.batchCount != -1 && batchIndex >= this.batchCount) {
                    return null;
                }
                this.queue.drainTo(this.executedBatches);
            }
        }

        void onBatchExecuted(BatchExecuted batch) {
            this.queue.add(batch);
        }

        void onBatchExecutedDone(int batchCount, int iTupleOrdinal, boolean setIterationDone) {
            this.batchCount = batchCount;
            this.iTupleOrdinal = iTupleOrdinal;
            this.setIterationDone = setIterationDone;
        }
    }

    static class Batch {
        final int index;
        final int tuplesOrdinal;
        final List<OlapTuple> tuples = new ArrayList<OlapTuple>();

        Batch(int index, int tuplesOrdinal) {
            this.index = index;
            this.tuplesOrdinal = tuplesOrdinal;
        }

        public String toString() {
            return "%d ordinal:%d tuples:%d".formatted(this.index, this.tuplesOrdinal, this.tuples.size());
        }
    }

    static class PrefetchBatchTask
    implements Runnable {
        private final GFParallelLambdaContext pContext;
        private final Prefetch prefetch;
        private final Batch batch;
        private final GFIteratorGutsMT_ acceptor;

        public PrefetchBatchTask(GFParallelLambdaContext pContext, Prefetch prefetch, Batch batch, GFIteratorGutsMT_ acceptor) {
            this.pContext = pContext;
            this.prefetch = prefetch;
            this.batch = batch;
            this.acceptor = acceptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Deque<Object> executed = null;
            try {
                OlapMdxStatementExecutionContext statementContext = this.pContext.getStatementExecutionContext();
                OlapSetEvaluationController controller = statementContext.getSetEvaluationController();
                try {
                    controller.initForParallelLambdaProcessing(this.pContext.fork());
                    executed = this.safeExecute(this.pContext, this.batch);
                }
                finally {
                    controller.clear();
                }
                this.prefetch.onBatchExecuted(new BatchExecuted(this.batch.index, this.batch.tuplesOrdinal, (Deque<OlapTuple>)(executed != null ? executed : new ArrayDeque())));
            }
            catch (Throwable throwable) {
                this.prefetch.onBatchExecuted(new BatchExecuted(this.batch.index, this.batch.tuplesOrdinal, (Deque<OlapTuple>)(executed != null ? executed : new ArrayDeque())));
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Deque<OlapTuple> safeExecute(GFParallelLambdaContext pContext, Batch batch) {
            GFParallelLambdaExecutionContext eContext = pContext.borrowExecutionContext();
            try {
                List<OlapTuple> tuples = batch.tuples;
                int tuplesOrdinal = batch.tuplesOrdinal;
                GFContext context = eContext.getContext();
                GFLambdaTupleEvaluator lambdaTupleEvaluator = eContext.getLambdaTupleEvaluator();
                GFMiniTupleEvaluator miniTupleEvaluator = eContext.getMiniTupleEvaluator();
                ArrayDeque<OlapTuple> prefetch = new ArrayDeque<OlapTuple>();
                for (int tt = 0; tt < tuples.size(); ++tt) {
                    int tupleOrdinal = tuplesOrdinal + tt + 1;
                    OlapTuple tuple = tuples.get(tt);
                    if (!this.acceptor.isAcceptingMT(context, miniTupleEvaluator, lambdaTupleEvaluator, tupleOrdinal, tuple)) continue;
                    prefetch.add(tuple);
                }
                ArrayDeque<OlapTuple> arrayDeque = prefetch;
                return arrayDeque;
            }
            finally {
                pContext.returnExecutionContext(eContext);
            }
        }
    }

    static class PrefetchDoneTask
    implements Runnable {
        private final GFParallelLambdaContext pContext;
        private final Prefetch prefetch;
        private final int batchCount;
        private final int iTupleOrdinal;
        private final boolean setIterationDone;

        public PrefetchDoneTask(GFParallelLambdaContext pContext, Prefetch prefetch, int batchCount, int iTupleOrdinal, boolean setIterationDone) {
            this.pContext = pContext;
            this.prefetch = prefetch;
            this.batchCount = batchCount;
            this.iTupleOrdinal = iTupleOrdinal;
            this.setIterationDone = setIterationDone;
        }

        @Override
        public void run() {
            this.prefetch.onBatchExecutedDone(this.batchCount, this.iTupleOrdinal, this.setIterationDone);
            this.prefetch.onBatchExecuted(new BatchExecuted(Integer.MAX_VALUE, -1, null));
        }
    }

    static class BatchExecuted {
        final int index;
        final int tuplesOrdinal;
        final Deque<OlapTuple> tuples;

        BatchExecuted(int index, int tuplesOrdinal, Deque<OlapTuple> tuples) {
            this.index = index;
            this.tuplesOrdinal = tuplesOrdinal;
            this.tuples = tuples;
        }

        @Nullable
        OlapTuple removeFirst() {
            if (this.tuples.isEmpty()) {
                return null;
            }
            return this.tuples.removeFirst();
        }

        public String toString() {
            return "%d ordinal:%d tuples:%d".formatted(this.index, this.tuplesOrdinal, this.tuples.size());
        }
    }
}

