/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaListener;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaExecutionContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIteratorGuts;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationController;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class GFIteratorGutsMT
extends GFIteratorGuts {
    private static final GFApplyLambdaCallback CALLBACK_NOP = new GFApplyLambdaCallback(null, null, null, null){

        @Override
        public OlapLambdaCallbackMode processingMode() {
            return OlapLambdaCallbackMode.PARALLEL;
        }

        @Override
        public OlapEntity onDone(GFContext context) {
            return OlapSetFactory.empty();
        }
    };
    private final int prefetchMaxCount;
    private final int threadCount;
    private final int batchSize;
    private final ExecutorService pool;
    private final GFParallelLambdaContext pContext;
    private volatile boolean shutdown;
    private boolean setIterationDone;
    private int iTupleOrdinal;
    @Nullable
    private Prefetch prefetch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFIteratorGutsMT(GFContext contextForked, GFTupleEvaluator evaluator, GFNode debuggerNode, @Nullable GFApplyLambdaListener debugger, boolean nonEmptyFunction, boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFNode setN, @Nullable GFNode lambdaN, OlapTupleSet set, OlapIterator<OlapTuple> setIterator, long setFastEstimatedSize, int limit, int prefetchMaxCount, int threadCount, int batchSize) {
        super(contextForked, evaluator, debuggerNode, debugger, nonEmptyFunction, markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args, setN, lambdaN, set, setIterator, setFastEstimatedSize, limit);
        this.prefetchMaxCount = prefetchMaxCount;
        this.threadCount = threadCount;
        this.batchSize = batchSize;
        this.shutdown = false;
        this.setIterationDone = false;
        this.iTupleOrdinal = 0;
        this.prefetch = null;
        OlapMdxStatementExecutionContext statementContext = contextForked.getStatementExecutionContext();
        OlapSetEvaluationController controller = statementContext.getSetEvaluationController();
        OlapStack<OlapSetDeclaration> fork = controller.forkForParallelLambdaProcessing();
        this.pContext = new GFParallelLambdaContext(fork, contextForked, evaluator, null, threadCount, this.applyLambdaNode, set, setFastEstimatedSize, CALLBACK_NOP);
        this.pool = Executors.newFixedThreadPool(this.threadCount);
        try {
            ((ThreadPoolExecutor)this.pool).prestartAllCoreThreads();
        }
        finally {
            statementContext.registerHousekeeper(this::shutdownNow);
        }
    }

    private void shutdownNow() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s parallel iterator housekeeping".formatted(this.pContext.getFunctionName()));
        this.pool.shutdownNow();
    }

    @Override
    protected void onSafeNextCompleted() {
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s parallel iterator on-safe-next completed".formatted(this.pContext.getFunctionName()));
        this.shutdownNow();
    }

    @Override
    @Nullable
    protected OlapTuple doSafeNext() {
        while (true) {
            OlapTuple tuple;
            if (this.prefetch == null) {
                this.prefetch();
                if (this.prefetch == null) {
                    this.shutdownNow();
                    return null;
                }
            }
            if ((tuple = this.prefetch.removeFirst()) != null) {
                return tuple;
            }
            this.prefetch = null;
            if (!this.pContext.isCancelling()) continue;
            this.prefetch = null;
            this.setIterationDone = true;
        }
    }

    private void prefetch() {
        OlapTuple iTuple;
        if (this.pContext.isCancelling()) {
            this.prefetch = null;
            this.setIterationDone = true;
            return;
        }
        if (this.prefetch != null) {
            throw new RuntimeException("internal error : unexpected prefetch");
        }
        if (this.setIterationDone) {
            return;
        }
        int prefetchedCount = 0;
        GFBatch batch = new GFBatch(this.iTupleOrdinal);
        while ((iTuple = (OlapTuple)this.setIterator.next()) != null) {
            ++this.iTupleOrdinal;
            batch.tuples.add(iTuple);
            if (batch.tuples.size() >= this.batchSize) {
                this.prefetch = Prefetch.add(this.prefetch, this.pContext, this.execute(this.pContext, batch));
                batch = new GFBatch(this.iTupleOrdinal);
            }
            if (++prefetchedCount < this.prefetchMaxCount) continue;
        }
        if (!batch.tuples.isEmpty()) {
            this.prefetch = Prefetch.add(this.prefetch, this.pContext, this.execute(this.pContext, batch));
        }
        if (this.prefetch != null) {
            this.prefetch.addCompleted();
        }
        if (iTuple == null) {
            this.setIterationDone = true;
        }
    }

    private Future<Deque<OlapTuple>> execute(GFParallelLambdaContext pContext, GFBatch batch) {
        return this.pool.submit(() -> {
            OlapMdxStatementExecutionContext statementContext = pContext.getStatementExecutionContext();
            OlapSetEvaluationController controller = statementContext.getSetEvaluationController();
            try {
                controller.initForParallelLambdaProcessing(pContext.fork());
                Deque<OlapTuple> deque = this.safeExecute(pContext, batch);
                return deque;
            }
            finally {
                controller.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deque<OlapTuple> safeExecute(GFParallelLambdaContext pContext, GFBatch batch) {
        GFParallelLambdaExecutionContext eContext = pContext.borrowExecutionContext();
        try {
            List<OlapTuple> tuples = batch.tuples;
            int tuplesOrdinal = batch.tuplesOrdinal;
            GFContext context = eContext.getContext();
            GFLambdaTupleEvaluator lambdaTupleEvaluator = eContext.getLambdaTupleEvaluator();
            GFMiniTupleEvaluator miniTupleEvaluator = eContext.getMiniTupleEvaluator();
            ArrayDeque<OlapTuple> prefetch = new ArrayDeque<OlapTuple>();
            for (int tt = 0; tt < tuples.size(); ++tt) {
                if (this.shutdown) {
                    OlapLoggers.MDX_EVALUATION.error((Object)"[mdx] %s parallel iteration interrupted on shutdown".formatted(pContext.getFunctionName()));
                    break;
                }
                int tupleOrdinal = tuplesOrdinal + tt + 1;
                OlapTuple tuple = tuples.get(tt);
                if (!this.isAcceptingMT(context, miniTupleEvaluator, lambdaTupleEvaluator, tupleOrdinal, tuple)) continue;
                prefetch.add(tuple);
            }
            ArrayDeque<OlapTuple> arrayDeque = prefetch;
            return arrayDeque;
        }
        finally {
            pContext.returnExecutionContext(eContext);
        }
    }

    static class Prefetch {
        private final GFParallelLambdaContext context;
        private final Deque<Future<Deque<OlapTuple>>> batches = new ArrayDeque<Future<Deque<OlapTuple>>>();
        private boolean addCompleted;
        @Nullable
        private Deque<OlapTuple> first;

        Prefetch(GFParallelLambdaContext context, Future<Deque<OlapTuple>> batch) {
            this.context = context;
            this.batches.add(batch);
        }

        static Prefetch add(@Nullable Prefetch prefetch, GFParallelLambdaContext context, Future<Deque<OlapTuple>> batch) {
            if (prefetch == null) {
                return new Prefetch(context, batch);
            }
            if (prefetch.addCompleted) {
                throw new RuntimeException("internal error : unexpected prefetch add");
            }
            prefetch.batches.add(batch);
            return prefetch;
        }

        void addCompleted() {
            this.addCompleted = true;
            this.first = null;
        }

        @Nullable
        OlapTuple removeFirst() {
            if (!this.addCompleted) {
                throw new RuntimeException("internal error : unexpected prefetch usage");
            }
            if (this.first != null && !this.first.isEmpty()) {
                OlapTuple tuple = this.first.removeFirst();
                return tuple;
            }
            while (!this.batches.isEmpty()) {
                this.first = this.getFirstBatch();
                if (this.first.isEmpty()) {
                    this.batches.removeFirst();
                    continue;
                }
                OlapTuple tuple = this.first.removeFirst();
                return tuple;
            }
            return null;
        }

        Deque<OlapTuple> getFirstBatch() {
            try {
                return this.batches.getFirst().get();
            }
            catch (ExecutionException ex) {
                OlapLoggers.MDX_EVALUATION.error((Object)"[mdx] %s parallel iteration error".formatted(this.context.getFunctionName()), (Throwable)ex);
                Throwable actual = ex.getCause();
                if (actual instanceof OlapEvaluationException) {
                    OlapEvaluationException eval = (OlapEvaluationException)((Object)actual);
                    throw eval;
                }
                if (actual instanceof StackOverflowError) {
                    StackOverflowError so = (StackOverflowError)actual;
                    throw so;
                }
                throw new OlapEvaluationException(ex, this.context.getErrorContext(), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()});
            }
            catch (InterruptedException ex) {
                OlapLoggers.MDX_EVALUATION.info((Object)"[mdx] %s parallel iteration interrupted".formatted(this.context.getFunctionName()));
                return null;
            }
        }
    }

    static class GFBatch {
        final int tuplesOrdinal;
        final List<OlapTuple> tuples = new ArrayList<OlapTuple>();

        GFBatch(int tuplesOrdinal) {
            this.tuplesOrdinal = tuplesOrdinal;
        }
    }
}

