/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaListener;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNonEmptyApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import org.jetbrains.annotations.Nullable;

public abstract class GFIteratorGuts {
    private final GFContext contextForked;
    private final GFNode debuggerNode;
    @Nullable
    private final GFApplyLambdaListener debugger;
    private final OlapTupleSet set;
    protected final OlapIterator<OlapTuple> setIterator;
    private final int limit;
    protected final GFApplyLambdaNode applyLambdaNode;
    private final GFLambdaTupleEvaluator lambdaTupleEvaluator;
    private final GFMiniTupleEvaluator miniTupleEvaluator;
    private boolean done;
    private int filteredTupleCount;

    public GFIteratorGuts(GFContext contextForked, GFTupleEvaluator evaluator, GFNode debuggerNode, @Nullable GFApplyLambdaListener debugger, boolean nonEmptyFunction, boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFNode setN, @Nullable GFNode lambdaN, OlapTupleSet set, OlapIterator<OlapTuple> setIterator, long setFastEstimatedSize, int limit) {
        this.contextForked = contextForked;
        this.debuggerNode = debuggerNode;
        this.debugger = debugger;
        this.set = set;
        this.limit = limit;
        this.applyLambdaNode = nonEmptyFunction ? new GFNonEmptyApplyLambdaNode(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args, null, lambdaN, 0, setN, limit) : new GFGenericApplyLambdaNode(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args, null, lambdaN, 0, setN, limit);
        this.lambdaTupleEvaluator = this.applyLambdaNode.createLambdaTupleEvaluator(contextForked, evaluator, setFastEstimatedSize);
        this.miniTupleEvaluator = new GFMiniTupleEvaluator(null, this.lambdaTupleEvaluator);
        this.miniTupleEvaluator.onRootCalcMemberEvalStarted(contextForked);
        this.setIterator = setIterator;
        this.setIterator.reset();
        this.done = false;
        this.filteredTupleCount = 0;
    }

    public String getFunctionName() {
        return this.applyLambdaNode.getFunctionName();
    }

    @Nullable
    public OlapTuple safeNext() {
        if (this.done || this.limit != -1 && this.filteredTupleCount >= this.limit) {
            this.onSafeNextCompleted();
            return null;
        }
        OlapTuple tuple = this.doSafeNext();
        if (tuple != null) {
            ++this.filteredTupleCount;
        } else {
            this.onSafeNextCompleted();
            this.done = true;
        }
        return tuple;
    }

    @Nullable
    protected abstract OlapTuple doSafeNext();

    protected void onSafeNextCompleted() {
    }

    protected boolean isAcceptingST(int iTupleOrdinal, OlapTuple iTuple) {
        return GFIteratorGuts.isAccepting(this.contextForked, this.miniTupleEvaluator, this.lambdaTupleEvaluator, this.debuggerNode, this.debugger, this.set, iTupleOrdinal, iTuple);
    }

    protected boolean isAcceptingMT(GFContext contextMT, GFMiniTupleEvaluator miniTupleEvaluatorMT, GFLambdaTupleEvaluator lambdaTupleEvaluatorMT, int iTupleOrdinal, OlapTuple iTuple) {
        return GFIteratorGuts.isAccepting(contextMT, miniTupleEvaluatorMT, lambdaTupleEvaluatorMT, this.debuggerNode, null, this.set, iTupleOrdinal, iTuple);
    }

    private static boolean isAccepting(GFContext contextForked, GFMiniTupleEvaluator miniTupleEvaluator, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFNode debuggerNode, @Nullable GFApplyLambdaListener debugger, OlapTupleSet set, int iTupleOrdinal, OlapTuple iTuple) {
        boolean accepted;
        OlapEntity[] evaluated = new OlapEntity[1];
        if (debugger != null) {
            GFIteratorGuts.evalLambdaAndListen(contextForked, miniTupleEvaluator, lambdaTupleEvaluator, set, debuggerNode, debugger, iTupleOrdinal, iTuple, evaluated);
        } else {
            GFIteratorGuts.evalLambda(contextForked, miniTupleEvaluator, lambdaTupleEvaluator, set, iTupleOrdinal, iTuple, evaluated);
        }
        OlapEntity evaluatedLambda = evaluated[0];
        if (evaluatedLambda == null || evaluatedLambda.isMdxNull()) {
            accepted = false;
        } else if (evaluatedLambda instanceof OlapScalarEntity) {
            OlapScalarEntity scalar = (OlapScalarEntity)evaluatedLambda;
            accepted = OlapScalarOperators.isTrue(scalar);
        } else {
            accepted = false;
        }
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void evalLambdaAndListen(GFContext contextForked, GFMiniTupleEvaluator miniTupleEvaluator, GFLambdaTupleEvaluator lambdaTupleEvaluator, OlapTupleSet set, GFNode debuggerNode, GFApplyLambdaListener debugger, int iTupleOrdinal, OlapTuple iTuple, OlapEntity[] evaluated) {
        if (debugger.countForInstrListening++ >= 25) {
            contextForked.stopInstrExecListening(debuggerNode);
        }
        debugger.listener.onFactSetTupleIteration(debuggerNode);
        if (contextForked.isInstrExecListening()) {
            debugger.listener.beginFactSetTupleIteration(debuggerNode, iTuple);
        }
        try {
            GFIteratorGuts.evalLambda(contextForked, miniTupleEvaluator, lambdaTupleEvaluator, set, iTupleOrdinal, iTuple, evaluated);
        }
        finally {
            debugger.listener.onFactSetTupleIterationCompleted(debuggerNode);
            if (contextForked.isInstrExecListening()) {
                debugger.listener.endFactSetTupleIteration(debuggerNode, iTuple, evaluated[0]);
            }
            contextForked.setInstrExecListening(true);
        }
    }

    private static void evalLambda(GFContext contextForked, GFMiniTupleEvaluator miniTupleEvaluator, GFLambdaTupleEvaluator lambdaTupleEvaluator, OlapTupleSet set, int iTupleOrdinal, OlapTuple iTuple, OlapEntity[] evaluated) {
        lambdaTupleEvaluator.evaluate(contextForked, miniTupleEvaluator, evaluated, set, iTuple, iTupleOrdinal, null);
    }
}

