/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.configuration.component.properties.OlapFilterProcessingMode;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallbackFactory;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaListener;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIteratorGuts;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIteratorGutsMT;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIteratorGutsST;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxExtraExecutionLock;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFIterator
extends OlapBaseIterator<OlapTuple> {
    private final GFContext contextForked;
    private final GFTupleEvaluator evaluator;
    private final GFNode debuggerNode;
    private final OlapFilterProcessingMode mode;
    private final GFApplyLambdaCallbackFactory callbackFactory;
    private final boolean nonEmptyFunction;
    private final boolean markedForValueEvaluation;
    private final OlapFunctionCallInstr functionCallInstr;
    private final OlapInstr[] functionCallArgInstrs;
    private final OlapFunction function;
    private final GFNode[] args;
    private final GFNode setN;
    @Nullable
    private final GFNode lambdaN;
    private final GFFunctionArgs funArgs;
    private final OlapTupleSet set;
    private final long setFastEstimatedSize;
    private final int limit;
    private OlapIterator<OlapTuple> setIterator;
    private boolean used;
    @Nullable
    private GFIteratorGuts guts;

    public GFIterator(GFContext contextForked, GFTupleEvaluator evaluator, GFNode debuggerNode, OlapFilterProcessingMode mode, GFApplyLambdaCallbackFactory callbackFactory, boolean nonEmptyFunction, boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFNode setN, @Nullable GFNode lambdaN, GFFunctionArgs funArgs, OlapTupleSet set, OlapIterator<OlapTuple> setIterator, long setFastEstimatedSize, int limit) {
        this.contextForked = contextForked;
        this.evaluator = evaluator;
        this.debuggerNode = debuggerNode;
        this.mode = mode;
        this.callbackFactory = callbackFactory;
        this.nonEmptyFunction = nonEmptyFunction;
        this.markedForValueEvaluation = markedForValueEvaluation;
        this.functionCallInstr = functionCallInstr;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.args = args;
        this.setN = setN;
        this.lambdaN = lambdaN;
        this.funArgs = funArgs;
        this.set = set;
        this.setFastEstimatedSize = setFastEstimatedSize;
        this.limit = limit;
        this.setIterator = setIterator;
        this.used = false;
    }

    @Override
    public boolean isCacheUseless() {
        return false;
    }

    @Override
    public boolean isCrossjoin() {
        return false;
    }

    @Override
    public boolean isMembersCrossjoin() {
        return this.setIterator.isMembersCrossjoin() || super.isMembersCrossjoin();
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.setIterator.getTupleDimensionality();
    }

    @Override
    public long fastEstimatedSize() {
        return this.setIterator.fastEstimatedSize();
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.setIterator.mightHaveCalcMember();
    }

    @Override
    public OlapIterator<OlapTuple> fastCrossjoinForNonEmptyProcessing(OlapFastCrossjoinContext crossjoinContext) {
        if (this.guts != null) {
            throw new RuntimeException("internal error : inconsistent usage of fastCrossjoinForNonEmptyProcessing in %s".formatted(this.function.getName()));
        }
        OlapFastCrossjoinContext cContext = crossjoinContext.newInstanceForCrossjoinIterator();
        OlapIterator<OlapTuple> optimized = this.setIterator.fastCrossjoinForNonEmptyProcessing(cContext);
        if (optimized == null) {
            return null;
        }
        this.setIterator = optimized;
        return this;
    }

    @Override
    @Nullable
    public List<OlapMember> tryExtractMeasures(OlapHierarchy measureHierarchy) {
        return super.tryExtractMeasures(measureHierarchy);
    }

    @Override
    public List<List<OlapTuple>> asCrossjoinMaterializedTuples() {
        return OlapIterator.asCrossjoinMaterializedTuples(this);
    }

    @Override
    public OlapIterator<OlapTuple> newInstance() {
        return new GFIterator(this.contextForked.forkForParallelLambdaProcessing(), this.evaluator, this.debuggerNode, this.mode, this.callbackFactory, this.nonEmptyFunction, this.markedForValueEvaluation, this.functionCallInstr, this.functionCallArgInstrs, this.function, this.args, this.setN, this.lambdaN, this.funArgs, this.set, this.setIterator, this.setFastEstimatedSize, this.limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        OlapMdxStatementExecutionContext sContext;
        OlapMdxExtraExecutionLock mtEvalLock;
        if (this.used) {
            throw new OlapEvaluationException(this.functionCallInstr.getLocationRange(), OlapErrorCode.DUPLICATED_ITERATION, new Serializable[]{this.function.getName()});
        }
        GFApplyLambdaListener debugger = GFApplyLambdaListener.setup(this.contextForked);
        boolean parallel = false;
        int parallelTC = -1;
        if (debugger == null && this.contextForked.isLambdaParallelProcessingEnabled(this.evaluator) && this.mode == OlapFilterProcessingMode.ITERATOR && (mtEvalLock = (sContext = this.contextForked.getStatementExecutionContext()).acquireMdxExtraExecutionLock()) != null) {
            try {
                parallel = true;
                parallelTC = mtEvalLock.getParallelExecutorX().threadCount();
                if (parallelTC <= 0) {
                    parallelTC = CdSystemUtils.availableProcessors();
                }
                if (parallelTC < 2) {
                    parallel = false;
                }
            }
            finally {
                sContext.releaseMdxExtraExecutionLock(mtEvalLock);
            }
        }
        if (!parallel) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s() sequential iterator reset [size:%s] [limit:%s]".formatted(this.functionCallInstr.getFunctionName(), CdStringUtils.formatNice((long)this.setFastEstimatedSize), CdStringUtils.formatNice((long)this.limit)));
            this.guts = new GFIteratorGutsST(this.contextForked, this.evaluator, this.debuggerNode, debugger, this.nonEmptyFunction, this.markedForValueEvaluation, this.functionCallInstr, this.functionCallArgInstrs, this.function, this.args, this.setN, this.lambdaN, this.set, this.setIterator, this.setFastEstimatedSize, this.limit);
        } else {
            int prefetchMaxCount = 8192;
            int batchSize = 32;
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s() parallel iterator (prefetch-size:%d, thread-count:%d, batch-size:%d) reset [size:%s] [limit:%s]".formatted(this.functionCallInstr.getFunctionName(), 8192, parallelTC, 32, CdStringUtils.formatNice((long)this.setFastEstimatedSize), CdStringUtils.formatNice((long)this.limit)));
            this.guts = new GFIteratorGutsMT(this.contextForked, this.evaluator, this.debuggerNode, null, this.nonEmptyFunction, this.markedForValueEvaluation, this.functionCallInstr, this.functionCallArgInstrs, this.function, this.args, this.setN, this.lambdaN, this.set, this.setIterator, this.setFastEstimatedSize, this.limit, 8192, parallelTC, 32);
        }
    }

    @Override
    @Nullable
    protected OlapTuple safeNext() {
        this.used = true;
        if (this.guts == null) {
            throw new RuntimeException("internal error : iteration wo/ reset in %s".formatted(this.function.getName()));
        }
        return this.guts.safeNext();
    }
}

