/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapStackOverflowEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import org.jetbrains.annotations.Nullable;

public class GFIsEmptyTupleNode
extends GFNode {
    private final OlapFunctionCallInstr functionCallInstr;
    private final OlapTuple tuple;

    public GFIsEmptyTupleNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapTuple tuple) {
        super(markedForValueEvaluation);
        this.functionCallInstr = functionCallInstr;
        this.tuple = tuple;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.functionCallInstr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.functionCallInstr.getMdxForDrillthrough();
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return OlapTupleDimensionalityFactory.createForNullEntity();
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        GFContext.Mark mark = null;
        try {
            mark = context.mark();
            OlapBooleanEntity res = this.isEmpty(context, evaluator);
            return res;
        }
        catch (OlapEvaluationException ex) {
            if (ex instanceof OlapStackOverflowEvaluationException) {
                throw ex;
            }
            context.resetToMark(mark);
            return OlapBooleanEntity.FALSE;
        }
    }

    private OlapBooleanEntity isEmpty(GFContext context, GFTupleEvaluator evaluator) {
        OlapScalarEntity res = context.isEmptyValue(evaluator, this.tuple);
        return OlapBooleanEntity.value(res.isMdxNull());
    }
}

