/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapIntrinsicMemberPropertyCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import java.io.Serializable;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFIntrinsicMemberPropertyCallNode
extends GFNode {
    private final OlapIntrinsicMemberPropertyCallInstr instr;
    private final OlapIntrinsicMemberProperty property;
    private final GFNode member;

    public GFIntrinsicMemberPropertyCallNode(boolean markedForValueEvaluation, OlapIntrinsicMemberPropertyCallInstr instr, OlapIntrinsicMemberProperty property, GFNode member) {
        super(markedForValueEvaluation);
        this.instr = instr;
        this.property = property;
        this.member = member;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return null;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.member.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapMember nullableMember;
        OlapEntity memberEntity = this.member.execute(context, evaluator);
        if (memberEntity.isMdxNull()) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (memberEntity.isToMemberApplicable(context.getPrepareContext())) {
            nullableMember = memberEntity.toNullableMember(context.getPrepareContext());
            if (nullableMember == null) {
                return OlapEmptyEntity.INSTANCE;
            }
        } else {
            throw new OlapEvaluationException(context, OlapErrorCode.PROPERTY_TYPE_MISMATCH, new Serializable[]{this.property.getName(), "member", memberEntity.getFriendlyTypeName()});
        }
        OlapMember member = nullableMember;
        OlapScalarEntity value = this.property.eval(context.getMemberPropertyEvalContext(), member);
        return value;
    }

    @Override
    public String toStringForDebugger() {
        return this.instr.toStringForDebugger();
    }
}

