/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFFunctionCallExecutor;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFFunctionCallNode<F extends OlapFunction>
extends GFNode {
    protected final GFNode[] args;
    protected final OlapFunctionCallInstr functionCallInstr;
    protected final OlapInstr[] functionCallArgInstrs;
    protected final F function;

    public GFFunctionCallNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, F function, GFNode[] args) {
        super(markedForValueEvaluation);
        this.functionCallInstr = functionCallInstr;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.args = args;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.functionCallInstr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.functionCallInstr.getMdxForDrillthrough();
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return ((OlapFunction)this.function).nonEmptyBehavior(context, this.args);
    }

    public F getFunction() {
        return this.function;
    }

    public String getFunctionName() {
        return ((OlapFunction)this.function).getName();
    }

    public OlapFunctionCallInstr getFunctionCallInstr() {
        return this.functionCallInstr;
    }

    public OlapInstr[] getFunctionCallArgInstrs() {
        return this.functionCallArgInstrs;
    }

    public GFNode[] getArgs() {
        return this.args;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return ((OlapFunction)this.function).getTupleDimensionality(this.args);
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        for (GFNode arg : this.args) {
            arg.forEachNode(consumer);
        }
    }

    protected GFFunctionCallExecutor createFunctionExecutor(GFFunctionArgs funArgs) {
        return new GFFunctionCallExecutor(funArgs, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        Object mark = context.markAsNamedSet_();
        try {
            OlapEntity olapEntity = this.doEvaluate(context, evaluator);
            return olapEntity;
        }
        finally {
            context.resetAsNamedSetToMark_(mark);
        }
    }

    protected OlapEntity doEvaluate(GFContext context, GFTupleEvaluator evaluator) {
        GFFunctionArgs funArgs = new GFFunctionArgs(evaluator, this.functionCallInstr, this.functionCallArgInstrs, (OlapFunction)this.function, this.args);
        GFFunctionCallExecutor executor = this.createFunctionExecutor(funArgs);
        executor.assertArgumentCount(context, funArgs);
        OlapEntity res = executor.execute(context, evaluator);
        return res;
    }

    @Override
    public String toStringForDebugger() {
        OlapFunctionArgs args = ((OlapFunction)this.function).getArgsInfo();
        String name = ((OlapFunction)this.function).getName();
        return name + "(" + args.toStringForDebugger() + ")";
    }

    public String toString() {
        return ((OlapFunction)this.function).getName();
    }
}

