/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFSetNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.set.OlapSetInstr;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFDynamicSetNode
extends GFSetNode {
    private final GFNode[] items;

    public GFDynamicSetNode(boolean markedForValueEvaluation, OlapInstr instr, GFNode[] items) {
        super(markedForValueEvaluation, instr);
        this.items = items;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return null;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        for (GFNode item : this.items) {
            item.forEachNode(consumer);
        }
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        ArrayList<OlapEntity> entities = new ArrayList<OlapEntity>();
        for (int ii = 0; ii < this.items.length; ++ii) {
            GFNode item = this.items[ii];
            OlapEntity entity = item.execute(context, evaluator);
            if (entity.isMdxNull()) continue;
            entities.add(entity);
        }
        OlapTupleSet<? extends OlapTuple> asSet = this.createSet(context.getPrepareContext(), entities);
        return asSet;
    }

    private OlapTupleSet<? extends OlapTuple> createSet(IOlapPrepareContext context, List<OlapEntity> entities) {
        if (entities.isEmpty()) {
            return OlapSetFactory.empty();
        }
        int memberCount = 0;
        int tupleCount = 0;
        for (OlapEntity entity : entities) {
            if (entity instanceof OlapMember || entity.isToMemberApplicable(context) && !(entity instanceof OlapTuple)) {
                ++memberCount;
                continue;
            }
            if (entity.isToTupleApplicable(context)) {
                ++tupleCount;
                continue;
            }
            if (entity.isToSetApplicable(context)) continue;
            return (OlapTupleSet)this.onTypeMismatchError(context, "member/tuple/set", entity.getFriendlyTypeName());
        }
        if (memberCount == entities.size()) {
            return GFDynamicSetNode.doCreateMemberSet(context, entities);
        }
        if (tupleCount == entities.size()) {
            return GFDynamicSetNode.doCreateTupleSet(context, entities);
        }
        return GFDynamicSetNode.doCreateSet(context, entities);
    }

    private static OlapTupleSet<OlapMember> doCreateMemberSet(IOlapPrepareContext context, List<OlapEntity> entities) {
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        OlapMember prevMember = null;
        for (OlapEntity entity : entities) {
            OlapMember member = entity.toNullableMember(context);
            if (member == null) continue;
            if (prevMember != null) {
                OlapTupleDimensionalityHelper.assertDimensionality((IOlapEvaluationExceptionContext)context, prevMember, member);
            }
            members.add(member);
            prevMember = member;
        }
        return OlapSetFactory.instance(members);
    }

    private static OlapListTupleSet<OlapTuple> doCreateTupleSet(IOlapPrepareContext context, List<OlapEntity> entities) {
        ArrayList<OlapTuple> tuples = new ArrayList<OlapTuple>();
        for (OlapEntity entity : entities) {
            OlapTuple tuple = entity.toTuple(context);
            if (!OlapSetInstr.isTupleValidForSet(context.getMemberTupleFilter(), tuple)) continue;
            tuples.add(tuple);
        }
        OlapTupleDimensionalityHelper.assertDimensionality(context, tuples);
        return OlapSetFactory.instance(tuples);
    }

    private static OlapTupleSet<? extends OlapTuple> doCreateSet(IOlapPrepareContext context, List<OlapEntity> entities) {
        ArrayList<OlapTupleSet<? extends OlapTuple>> sets = new ArrayList<OlapTupleSet<? extends OlapTuple>>();
        for (OlapEntity entity : entities) {
            if (entity.isToTupleApplicable(context)) {
                OlapTuple tuple = entity.toTuple(context);
                if (!OlapSetInstr.isTupleValidForSet(context.getMemberTupleFilter(), tuple)) continue;
                sets.add(OlapSetFactory.singleton(tuple));
                continue;
            }
            if (!entity.isToSetApplicable(context)) continue;
            OlapTupleSet<? extends OlapTuple> set = entity.toSet(context);
            sets.add(set);
        }
        OlapIterator<? extends OlapTuple> union = OlapIteratorFactory.union(context, sets, true);
        return OlapSetFactory.instance(union);
    }

    @Override
    public String toStringForDebugger() {
        return "{...}";
    }
}

