/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeRef;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class GFDeclaredFunctionCallNode
extends GFFunctionCallNode {
    private final GFNodeRef bodyRef;

    public GFDeclaredFunctionCallNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFNodeRef bodyRef) {
        super(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args);
        this.bodyRef = bodyRef;
    }

    @Override
    protected OlapEntity doEvaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapEntity[] params = this.doEvalParams(context, evaluator);
        OlapEntity res = this.doEvaluateWithParams(context, evaluator, params);
        return res;
    }

    @Nullable
    private OlapEntity[] doEvalParams(GFContext context, GFTupleEvaluator cache) {
        OlapEntity[] params = this.args.length > 0 ? this.executeDeclaredFunctionArgs(context, cache, this.function, this.args) : null;
        return params;
    }

    protected OlapEntity doEvaluateWithParams(GFContext context, GFTupleEvaluator evaluator, @Nullable OlapEntity[] params) {
        Object ref = context.pushFunctionCallFrame(this.getFunctionName(), params);
        GFNode body = this.bodyRef.getReferenced();
        OlapEntity res = body.execute(context, evaluator);
        context.popFunctionCallFrame(ref);
        return res;
    }

    protected OlapEntity[] executeDeclaredFunctionArgs(GFContext context, GFTupleEvaluator cache, OlapFunction function, GFNode[] args) {
        OlapFunctionArgs argsInfo = function.getArgsInfo();
        if (args.length < argsInfo.from || argsInfo.to < args.length) {
            throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, function.getName(), OlapErrorCode.FUNCTION_UNEXPECTED_ARGUMENT_COUNT_X, new Serializable[]{function.getName(), Integer.valueOf(args.length), argsInfo.toString()});
        }
        OlapEntity[] params = new OlapEntity[args.length];
        for (int idx = 0; idx < args.length; ++idx) {
            OlapEntity olapEntity = this.executeDeclaredFunctionArg(context, cache, function, args, idx);
            params[idx] = olapEntity.asConstant();
        }
        return params;
    }

    protected OlapEntity executeDeclaredFunctionArg(GFContext context, GFTupleEvaluator cache, OlapFunction function, GFNode[] args, int idx) {
        OlapFunctionArgs argsInfo = function.getArgsInfo();
        OlapFunctionArgumentType type = argsInfo.getType(idx);
        OlapInstrExecListener listener = context.getInstrExecListener();
        if (listener != null && context.isInstrExecListening()) {
            String argName = argsInfo.getName(idx);
            listener.beginFunctionArgEvaluation(argName, type);
        }
        try {
            OlapEntity value = this.executeArg(context, cache, args[idx], idx, type);
            if (listener != null && context.isInstrExecListening()) {
                listener.endFunctionArgEvaluation(value);
            }
            return value;
        }
        catch (RuntimeException ex) {
            if (listener != null && context.isInstrExecListening()) {
                listener.endFunctionArgEvaluationOnError(ex);
            }
            throw ex;
        }
    }

    private OlapEntity executeArg(GFContext context, GFTupleEvaluator cache, GFNode arg, int idx, OlapFunctionArgumentType type) {
        OlapEntity argEntity = arg.execute(context, cache);
        if (type != null && type.isValuable()) {
            if (argEntity.isMdxNull()) {
                return OlapEmptyEntity.INSTANCE;
            }
            if (argEntity.isToValueApplicable(context, cache)) {
                OlapScalarEntity argValue = argEntity.toValue(context, cache);
                return argValue;
            }
            return (OlapEntity)this.onExecutionError(context, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(idx + 1), "value", argEntity.getFriendlyTypeName(), ""});
        }
        return argEntity;
    }
}

