/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapDeclaredFunctionArgumentIdentifierInstr;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class GFDeclaredFunctionArgumentReferenceNode
extends GFNode {
    private final OlapDeclaredFunctionArgumentIdentifierInstr instr;
    private final String functionName;
    private final OlapDeclaredFunctionParameter parameter;

    public GFDeclaredFunctionArgumentReferenceNode(boolean markedForValueEvaluation, OlapDeclaredFunctionArgumentIdentifierInstr instr, String functionName, OlapDeclaredFunctionParameter parameter) {
        super(false);
        this.instr = instr;
        this.functionName = functionName;
        this.parameter = parameter;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    public boolean isConstrainedEnabled() {
        return false;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        OlapFunctionArgumentType type = this.parameter.getType();
        if (type != null && type.isValuable()) {
            return OlapTupleDimensionalityFactory.createForNullEntity();
        }
        return null;
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapEntity argument = context.lookupDeclaredFunctionArgument(this.parameter.getIndex());
        if (argument == null) {
            return (OlapEntity)this.onExecutionError(context, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"missing function argument : " + this.functionName + "." + this.parameter.getName()});
        }
        return argument;
    }

    @Override
    public String toStringForDebugger() {
        return this.parameter.getName();
    }
}

