/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFDeclaredFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeRef;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFConstFunctionTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStaticTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.mdx.OlapConstDeclaredFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class GFConstDeclaredFunctionCallNode
extends GFDeclaredFunctionCallNode {
    private final OlapConstDeclaredFunction functionC;
    private volatile OlapEntity result;

    public GFConstDeclaredFunctionCallNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapConstDeclaredFunction function, GFNode[] args, GFNodeRef bodyRef) {
        super(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args, bodyRef);
        this.functionC = function;
    }

    @Override
    protected OlapEntity doEvaluate(GFContext context, GFTupleEvaluator evaluator) {
        if (!this.functionC.isCached()) {
            OlapEntity res = this.doEvaluateWithParams(context, evaluator, null);
            return res;
        }
        if (this.result == null) {
            this.result = this.functionC.computeIfAbsent(() -> this.doEvaluateWithParams(context, evaluator, null));
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OlapEntity doEvaluateWithParams(GFContext context, GFTupleEvaluator evaluator, @Nullable OlapEntity[] params) {
        OlapMdxStatementExecutionContext sContext = context.getStatementExecutionContext();
        if (sContext.isSubSelect() || !sContext.hasEvaluatedSlicerAndSubSelect()) {
            throw new OlapEvaluationException(this.functionCallInstr.getLocationRange(), OlapErrorCode.CONST_FUNCTION_USAGE, new Serializable[]{this.function.getName(), "slicer/sub-select"});
        }
        try {
            GFContext constContext = context.onConstDeclaredFunctionStarted((OlapConstDeclaredFunction)this.function);
            GFStaticTupleEvaluator staticEvaluator = evaluator.getStaticEvaluator();
            GFConstFunctionTupleEvaluator constEvaluator = new GFConstFunctionTupleEvaluator(staticEvaluator);
            OlapTupleSet res = super.doEvaluateWithParams(constContext, constEvaluator, params);
            if (res instanceof OlapTupleSet) {
                OlapTupleSet asSet = res;
                res = asSet.materialize();
            }
            OlapTupleSet olapTupleSet = res;
            return olapTupleSet;
        }
        finally {
            context.onConstDeclaredFunctionCompleted();
        }
    }
}

