/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCalcMemberEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFMiniTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFCalcMemberEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFCalcMemberEvalNode
extends GFNode {
    private final OlapCalculatedMember calcMember;
    private final GFNode formulaNode;

    private GFCalcMemberEvalNode(boolean markedForValueEvaluation, OlapCalculatedMember calcMember, GFNode formulaNode) {
        super(markedForValueEvaluation);
        this.calcMember = calcMember;
        this.formulaNode = formulaNode;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.formulaNode.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.formulaNode.getMdxForDrillthrough();
    }

    public OlapCalculatedMember getCalcMember() {
        return this.calcMember;
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return this.formulaNode.nonEmptyBehavior(context);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.formulaNode.getTupleDimensionality();
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.formulaNode.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapScalarEntity res = GFCalcMemberEvalNode.execute(context, evaluator, this.calcMember, this.formulaNode);
        return res;
    }

    public static OlapScalarEntity evaluate(GFContext context, GFTupleEvaluator evaluator, GFCalcMemberEvalTuple evalTuple) {
        OlapCalculatedMember calcMember = evalTuple.getHighestPriorityMember();
        if (calcMember == null) {
            throw new RuntimeException("internal error: inconsistent tuple evaluation (invalid eval-tuple : missing calc. member)");
        }
        GFCalcMemberEvalNode.setupContext(context, evalTuple.isFromAxis(), calcMember);
        GFCalcMemberEvalContext cContext = context.asCalcMemberEvalContext();
        GFNode formulaNode = GFCalcMemberEvalNode.createFormulaNode(cContext, calcMember);
        OlapScalarEntity res = GFCalcMemberEvalNode.doEvaluate(cContext, evaluator, evalTuple, calcMember, formulaNode);
        return res;
    }

    private static OlapScalarEntity doEvaluate(GFContext context, GFTupleEvaluator evaluator, GFCalcMemberEvalTuple evalTuple, OlapCalculatedMember calcMember, GFNode node) {
        List<OlapMemberOrigin> tupleOrigins = evalTuple.completeTupleOrigins_(context);
        OlapTuple tuple = evalTuple.completeTuple_(context);
        GFTupleEvaluationFrame ref = context.pushEvaluatedTuple(tupleOrigins, tuple, calcMember);
        GFMiniTupleEvaluator evaluatorX = new GFMiniTupleEvaluator(null, evaluator);
        evaluatorX.onRootCalcMemberEvalStarted(context);
        OlapScalarEntity res = GFCalcMemberEvalNode.execute(context, evaluatorX, calcMember, node);
        evaluatorX.onRootCalcMemberEvalCompleted(context);
        context.popEvaluatedTuple(ref);
        return res;
    }

    public static OlapScalarEntity evaluate(GFContext context, GFMiniTupleEvaluator evaluator, GFMiniTupleEvaluationFrame miniTupleF) {
        OlapCalculatedMember calcMember = miniTupleF.calcMember();
        if (calcMember == null) {
            throw new RuntimeException("internal error: inconsistent tuple evaluation (invalid mini-tuple : missing calc. member)");
        }
        GFCalcMemberEvalNode.setupContext(context, false, calcMember);
        GFCalcMemberEvalContext cContext = context.asCalcMemberEvalContext();
        GFNode formulaNode = GFCalcMemberEvalNode.createFormulaNode(cContext, calcMember);
        OlapScalarEntity res = GFCalcMemberEvalNode.doEvaluate(cContext, evaluator, calcMember, formulaNode);
        return res;
    }

    private static OlapScalarEntity doEvaluate(GFContext context, GFMiniTupleEvaluator evaluator, OlapCalculatedMember calcMember, GFNode node) {
        OlapScalarEntity res = GFCalcMemberEvalNode.execute(context, evaluator, calcMember, node);
        return res;
    }

    private static GFNode createFormulaNode(GFCalcMemberEvalContext context, OlapCalculatedMember calcMember) {
        GFNode formulaNode = context.getOrCreateCalcMemberFormulaNode(calcMember);
        GFNode calcNode = context.getInstrExecListener() != null ? new GFCalcMemberEvalNode(true, calcMember, formulaNode) : formulaNode;
        return calcNode;
    }

    private static OlapScalarEntity execute(GFContext context, GFTupleEvaluator evaluator, OlapCalculatedMember calcMember, GFNode node) {
        OlapScalarEntity res = node.executeToScalar(context, evaluator, (ctxt, value) -> {
            throw new OlapEvaluationException(context, OlapErrorCode.CALC_MEMBER_TYPE_MISMATCH, new Serializable[]{calcMember.getUniqueName(context.getNameContext()), value.getFriendlyTypeName()});
        });
        return res;
    }

    private static void setupContext(GFContext context, boolean fromAxis, OlapCalculatedMember calcMember) {
        if (fromAxis) {
            context.setCellMeasure(calcMember);
        } else {
            context.setCellPropertyValueForCalcMember(calcMember);
        }
    }

    @Override
    public String toStringForDebugger() {
        return "Calc. Member";
    }
}

