/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.operator.binary.OlapBinaryOperator;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFBinaryOperatorNode
extends GFNode {
    protected final OlapInstr instr;
    protected final OlapBinaryOperator operator;
    protected final GFNode left;
    protected final GFNode right;

    public GFBinaryOperatorNode(boolean markedForValueEvaluation, OlapInstr instr, OlapBinaryOperator operator, GFNode left, GFNode right) {
        super(markedForValueEvaluation);
        this.instr = instr;
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public OlapBinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return this.operator.nonEmptyBehavior(context, this.left, this.right);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.operator.isAlwaysScalar() ? OlapTupleDimensionalityFactory.createForNullEntity() : null;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.left.forEachNode(consumer);
        this.right.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapEntity leftV = this.left.execute(context, evaluator);
        OlapEntity rightV = this.right.execute(context, evaluator);
        OlapEntity res = this.operator.execute(context, evaluator, leftV, rightV);
        return res;
    }

    @Override
    public String toStringForDebugger() {
        return this.operator.getName().mdx();
    }
}

