/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFAsNamedSetReferenceNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFSetNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.select.OlapAsNamedSetInstr;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFAsNamedSetNode
extends GFSetNode {
    private final String name;
    private final GFNode formula;

    public GFAsNamedSetNode(boolean markedForValueEvaluation, OlapAsNamedSetInstr instr, String name, GFNode formula) {
        super(markedForValueEvaluation, instr);
        this.name = name;
        this.formula = formula;
    }

    public GFAsNamedSetReferenceNode asReference() {
        return new GFAsNamedSetReferenceNode(this.markedForValueEvaluation, this);
    }

    public OlapTupleSet asNamedSet(GFContext context) {
        OlapTupleSet asNamedSet = context.lookupAsNamedSet_(this.name);
        if (asNamedSet == null) {
            return (OlapTupleSet)context.errorForMissingAsNamedSet(this.name);
        }
        return asNamedSet;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.formula.getTupleDimensionality();
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.formula.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapTupleSet<? extends OlapTuple> asNamedSet = this.evaluateSet(context, evaluator);
        context.pushAsNameSet_(asNamedSet);
        return asNamedSet;
    }

    private OlapTupleSet<? extends OlapTuple> evaluateSet(GFContext context, GFTupleEvaluator evaluator) {
        OlapEntity entity = this.formula.execute(context, evaluator);
        OlapTupleSet asSet = null;
        if (entity.isToSetApplicable(context.getPrepareContext())) {
            OlapTupleSet<? extends OlapTuple> asSet_ = entity.toSet(context.getPrepareContext());
            OlapSlicerFilter slicerTupleFilter = context.getSlicerTupleFilterForSetFiltering();
            asSet = OlapSetFactory.instance(slicerTupleFilter, asSet_);
        } else if (entity.isMdxNull()) {
            asSet = OlapSetFactory.empty();
        }
        if (asSet == null) {
            return (OlapTupleSet)this.onTypeMismatchError(context, "set", entity.getFriendlyTypeName());
        }
        return ((OlapTupleSet)asSet).convertToAsNamedSet(this.name);
    }

    @Override
    public boolean isCrossjoin() {
        return this.formula.isCrossjoin();
    }

    @Override
    public String toStringForDebugger() {
        return this.name;
    }
}

