/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallbackFactory;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaExecutor;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFGeneralLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public abstract class GFApplyLambdaNode
extends GFNode {
    protected final OlapFunctionCallInstr functionCallInstr;
    protected final OlapInstr[] functionCallArgInstrs;
    protected final OlapFunction function;
    protected final GFNode[] args;
    protected final GFApplyLambdaCallbackFactory callbackFactory;
    @Nullable
    protected final GFNode lambda1;
    @Nullable
    protected final GFNode lambda2;
    protected final boolean hasLambda2;
    protected final int setArgNb;
    protected final GFNode set;
    protected final int limitFromContext;
    @Nullable
    private final OlapTupleDimensionality setTupleDimensionality;

    public GFApplyLambdaNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFApplyLambdaCallbackFactory callbackFactory, @Nullable GFNode lambda, int setArgNb, GFNode set, int limitFromContext) {
        this(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args, callbackFactory, lambda, null, setArgNb, set, limitFromContext);
    }

    public GFApplyLambdaNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFApplyLambdaCallbackFactory callbackFactory, @Nullable GFNode lambda1, @Nullable GFNode lambda2, int setArgNb, GFNode set, int limitFromContext) {
        super(markedForValueEvaluation);
        this.functionCallInstr = functionCallInstr;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.args = args;
        this.callbackFactory = callbackFactory;
        this.lambda1 = lambda1;
        this.lambda2 = lambda2;
        this.hasLambda2 = lambda2 != null;
        this.setArgNb = setArgNb;
        this.set = set;
        this.setTupleDimensionality = set.getTupleDimensionality();
        this.limitFromContext = limitFromContext;
    }

    public String getFunctionName() {
        return this.functionCallInstr.getFunctionName();
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.functionCallInstr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.functionCallInstr.getMdxForDrillthrough();
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return this.function.nonEmptyBehavior(context, this.args);
    }

    public GFLambdaTupleEvaluator createLambdaTupleEvaluator(GFContext context, GFTupleEvaluator cache, double fastEstimatedSize) {
        OlapProperties properties = context.getRequestProperties();
        return new GFGeneralLambdaTupleEvaluator(properties, cache, this, fastEstimatedSize);
    }

    public boolean isEvaluatingNonScalarEntities() {
        return false;
    }

    public boolean isEvaluatingScalarEntities() {
        return !this.isEvaluatingNonScalarEntities();
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.setTupleDimensionality;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.set.forEachNode(consumer);
        if (this.lambda1 != null) {
            this.lambda1.forEachNode(consumer);
        }
        if (this.lambda2 != null) {
            this.lambda2.forEachNode(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        Object mark = context.markAsNamedSet_();
        try {
            OlapEntity res;
            GFFunctionArgs funArgs = new GFFunctionArgs(evaluator, this.functionCallInstr, this.functionCallArgInstrs, this.function, this.args);
            funArgs.assertArgumentCount(context);
            OlapEntity olapEntity = res = this.doEvaluate(context, evaluator, funArgs);
            return olapEntity;
        }
        finally {
            context.resetAsNamedSetToMark_(mark);
        }
    }

    protected OlapEntity doEvaluate(GFContext context, GFTupleEvaluator evaluator, GFFunctionArgs funArgs) {
        GFApplyLambdaExecutor executor = new GFApplyLambdaExecutor(funArgs, this);
        return executor.execute(context, evaluator);
    }

    public GFApplyLambdaCallback createCallback(GFContext context) {
        GFApplyLambdaCallback callback = this.callbackFactory.create(this.functionCallInstr, this.functionCallArgInstrs, this.function, context.getInternalTupleListCount(), this.limitFromContext);
        return callback;
    }

    @Nullable
    public GFNode getLambda1() {
        return this.lambda1;
    }

    @Nullable
    public GFNode getLambda2() {
        return this.lambda2;
    }

    public boolean hasLambda2() {
        return this.hasLambda2;
    }

    public OlapTupleSet getEvaluatedSet(GFContext context, GFFunctionArgs args) {
        OlapTupleSet<? extends OlapTuple> set = args.toSet(context, this.setArgNb, true);
        if (set == null) {
            return OlapSetFactory.empty();
        }
        return set;
    }

    @Override
    public String toStringForDebugger() {
        return this.functionCallInstr.toStringForDebugger();
    }
}

