/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.function;

import crazydev.common.collection.CdArrays;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapFunctionError;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.OlapFormatter;
import crazydev.iccube.olap.entity.properties.OlapFormatterKey;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.scalar.OlapAbstractStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.IGFStrToFunctionCallback;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsCluster;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.jetbrains.annotations.Nullable;

public class GFFunctionArgs {
    private final OlapFunctionCallInstr functionCallInstr;
    private final OlapInstr[] functionCallArgInstrs;
    private final OlapFunction function;
    private final GFNode[] args;
    private final OlapEntity[] evaluatedArgs;
    private final GFTupleEvaluator evaluator;

    public GFFunctionArgs(GFTupleEvaluator evaluator, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args) {
        if (functionCallArgInstrs.length != args.length) {
            throw new RuntimeException("internal error: inconsistent function arguments (" + functionCallArgInstrs.length + "/" + args.length + ")");
        }
        this.evaluator = evaluator;
        this.functionCallInstr = functionCallInstr;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.args = args;
        this.evaluatedArgs = new OlapEntity[args.length];
    }

    public GFTupleEvaluator getTupleEvaluator() {
        if (this.evaluator == null) {
            throw new RuntimeException("internal error: inconsistent function evaluation (missing evaluator)");
        }
        return this.evaluator;
    }

    public void assertArgumentCount(GFContext context) {
        this.assertArgumentCount(context, this.function.getArgsInfo());
    }

    public void assertArgumentCount(GFContext context, OlapFunctionArgs argsInfo) {
        if (this.args.length < argsInfo.from || Integer.MAX_VALUE != argsInfo.to && this.args.length > argsInfo.to) {
            this.onFunctionArgSizeError(context);
        }
    }

    public void assertDimensionality(GFContext context, OlapTuple left, OlapTuple right) {
        context.assertDimensionality(left, right);
    }

    public int size() {
        return this.args.length;
    }

    public <T> T onFunctionArgSizeError(GFContext context) {
        OlapFunctionArgs argsInfo = this.function.getArgsInfo();
        return this.onFunctionError(context, OlapErrorCode.FUNCTION_UNEXPECTED_ARGUMENT_COUNT, new Serializable[]{Integer.valueOf(this.args.length), argsInfo.toString()});
    }

    public <T> T onFunctionArgTypeMismatchError(GFContext context, int argNb, String expectedType, String actualType) {
        return this.onFunctionArgTypeMismatchError(context, argNb, expectedType, actualType, null);
    }

    public <T> T onFunctionArgTypeMismatchError(GFContext context, int argNb, String expectedType, String actualType, @Nullable String extraInfo) {
        return this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(argNb), expectedType, actualType, extraInfo == null ? "" : extraInfo});
    }

    public <T> T onFunctionArgNull(GFContext context, int argNb, String expectedType) {
        return this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_ARGUMENT_NULL, new Serializable[]{Integer.valueOf(argNb), expectedType});
    }

    public <T> T onFunctionArgMissing(GFContext context, int argNb, String expectedType) {
        return this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_ARGUMENT_MISSING, new Serializable[]{Integer.valueOf(argNb), expectedType});
    }

    public <T> T onFunctionError(GFContext context, int argNb, OlapErrorCode errCode, Serializable ... params) {
        throw new OlapFunctionEvaluationException(this.getErrorContext(context, argNb), this.function.getName(), errCode, params);
    }

    public <T> T onFunctionError(GFContext context, OlapErrorCode errCode, Serializable ... params) {
        throw new OlapFunctionEvaluationException(this.getErrorContext(context), this.function.getName(), errCode, params);
    }

    public <T> T onFunctionError(GFContext context, CdMdxException scanError) {
        CdError error = scanError.getError();
        CdErrorCode code = scanError.getErrorCode();
        CdErrorLocation location = scanError.getLocation();
        OlapInstrLocationRange functionLocation = this.getErrorContext(context).getErrorLocation();
        OlapFunctionError<OlapInstrLocationRange, CdErrorCode> functionError = new OlapFunctionError<OlapInstrLocationRange, CdErrorCode>(functionLocation, this.function.getName(), code, error.getParams());
        throw new OlapFunctionEvaluationException(functionError);
    }

    @Nullable
    public OlapInstrLocationRange getFunctionArgumentRange(int idx) {
        OlapInstr instr = idx < this.functionCallArgInstrs.length ? this.functionCallArgInstrs[idx] : null;
        OlapInstrLocationRange range = instr != null ? instr.getLocationRange() : null;
        return range;
    }

    public IOlapEvaluationExceptionContext getErrorContext(GFContext context) {
        return this.functionCallInstr.createErrorContext(this.getLocale(context), this.getNameContext(context), context.isDimensionalityCheck());
    }

    public IOlapEvaluationExceptionContext getErrorContext(GFContext context, int argNb) {
        if (!this.isMissingArg(argNb)) {
            return this.functionCallArgInstrs[argNb].createErrorContext(this.getLocale(context), this.getNameContext(context), context.isDimensionalityCheck());
        }
        return this.getErrorContext(context);
    }

    public boolean isMissingArg(int argNb) {
        return argNb < 0 || argNb >= this.args.length || this.args[argNb] == null || this.args[argNb].isMissingArg();
    }

    public int getArgLength() {
        return this.args.length;
    }

    public GFNode getArg(int argNb) {
        return this.args[argNb];
    }

    public void assertNotMissingArg(GFContext context, int argNb, String expectedType) {
        if (this.isMissingArg(argNb)) {
            throw new OlapFunctionEvaluationException(this.getErrorContext(context, argNb), this.functionCallInstr.getFunctionName(), OlapErrorCode.FUNCTION_ARGUMENT_MISSING, new Serializable[]{Integer.valueOf(argNb), expectedType});
        }
    }

    public OlapFunction getFunction() {
        return this.function;
    }

    public OlapEntity getNonMissingArgEntity(GFContext context, int argNb, String expectedType) {
        OlapEntity entity;
        this.assertNotMissingArg(context, argNb, expectedType);
        OlapEntity cached = this.evaluatedArgs[argNb];
        if (cached != null) {
            return cached;
        }
        GFNode arg = this.args[argNb];
        this.evaluatedArgs[argNb] = entity = arg.execute(context, this.evaluator);
        return entity;
    }

    public OlapProperties getRequestProperties(GFContext context) {
        return context.getRequestProperties();
    }

    public Locale getLocale(GFContext context) {
        return context.getLocale();
    }

    public String getUserName(GFContext context) {
        return context.getUserName();
    }

    public OlapNameContext getNameContext(GFContext context) {
        return context.getNameContext();
    }

    @Nullable
    public IOlapBigBrotherMgr getBigBrother(GFContext context) {
        return context.getBigBrother();
    }

    public List<OlapDimension> getAllDimensions(GFContext context) {
        return context.getAllDimensions();
    }

    public int getHierarchyCount(GFContext context) {
        return context.getHierarchyCount();
    }

    @Nullable
    public OlapHierarchy getDefaultTimeHierarchy(GFContext context) {
        return context.getDefaultTimeHierarchy();
    }

    public OlapTupleSet<OlapTuple> getAxis(GFContext context, int number) {
        return context.getAxis(number);
    }

    @Nullable
    public OlapTupleSet<OlapTuple> getSubSelectAxis(GFContext context, int number) {
        return context.getSubSelectAxis(number);
    }

    @Nullable
    public OlapTupleSet<OlapTuple> getSlicerSet(GFContext context) {
        return context.getSlicerSet();
    }

    public OlapSchema getSchema(GFContext context) {
        return context.getSchema();
    }

    public OlapCube getCube(GFContext context) {
        return context.getCube();
    }

    public String getUnderlyingCubeName(GFContext context) {
        return context.getUnderlyingCubeName();
    }

    public OlapEvalResultCellValue getCellValue(GFContext context) {
        return context.getCellValue();
    }

    public OlapTupleDimensionalityCache getTupleDimensionalityCache(GFContext context) {
        return context.getTupleDimensionalityCache();
    }

    public IOlapSchemaPermission getSchemaPermissions(GFContext context) {
        return context.getSchemaPermissions();
    }

    public IOlapSchemaPermission getSchemaPermissionsWithoutPerspective(GFContext context) {
        return context.getSchemaPermissionsWithoutPerspective();
    }

    public IOlapDimensionsPermission getDimensionsPermissions(GFContext context) {
        return context.getDimensionsPermissions();
    }

    public IOlapHierarchyPermission getHierarchyPermissions(GFContext context, OlapHierarchy hierarchy) {
        return context.getHierarchyPermissions(hierarchy);
    }

    public IOlapHierarchyPermission getHierarchyPermissionsWithoutPerspective(GFContext context, OlapHierarchy hierarchy) {
        return context.getHierarchyPermissionsWithoutPerspective(hierarchy);
    }

    public OlapNonScalarEntity lookupHierarchy(GFContext context, int position) {
        return context.lookupHierarchy(position);
    }

    public OlapNonScalarEntity lookupEntityByMdxIdentifier(GFContext context, OlapNameContext nameContext, int lookup, OlapEntityIdentifier identifier) {
        return context.lookupEntityByMdxIdentifier(nameContext, lookup, identifier);
    }

    @Nullable
    public OlapEntity lookupDeclaredFunctionArgument(GFContext context, int index) {
        return context.lookupDeclaredFunctionArgument(index);
    }

    @Nullable
    public OlapMemberFilter getMemberFilter(GFContext context) {
        return context.getMemberFilter();
    }

    @Nullable
    public OlapTupleFilter getMemberTupleFilter(GFContext context) {
        return context.getMemberTupleFilter();
    }

    @Nullable
    public OlapTupleFilter getTupleFilter(GFContext context) {
        return context.getTupleFilter();
    }

    @Nullable
    public OlapMemberFilter getSchemaPermissionsMemberFilter(GFContext context) {
        return context.getSchemaPermissionsMemberFilter();
    }

    @Nullable
    public OlapSlicerFilter getSlicerTupleFilterForSetFiltering(GFContext context) {
        return context.getSlicerTupleFilterForSetFiltering();
    }

    public List<OlapMember> getAllCalculatedMembers(GFContext context) {
        return context.getAllCalculatedMembers();
    }

    @Nullable
    public OlapMember getNullableCurrentMember(GFContext context, OlapHierarchy hierarchy) {
        return context.getNullableCurrentMember(hierarchy);
    }

    @Nullable
    public OlapNonScalarEntity getNullableCurrentMember(GFContext context, OlapHierarchy hierarchy, int idx) {
        return context.getNullableCurrentMember(hierarchy, idx);
    }

    @Nullable
    public OlapNonScalarEntity getNullableContextMember(GFContext context, OlapHierarchy hierarchy, int idx) {
        return context.getNullableContextMember(hierarchy, idx);
    }

    public OlapNonScalarEntity getContextMembers(GFContext context, OlapHierarchy hierarchy) {
        return context.getContextMembers(hierarchy);
    }

    public OlapNonScalarEntity getDeclaredMembers(GFContext context, OlapHierarchy hierarchy) {
        return context.getDeclaredMembers(hierarchy);
    }

    public OlapTuple getIteratedTuple(GFContext context, OlapTupleSet set) {
        return context.getIteratedTuple(set);
    }

    public OlapNumericEntity getIteratedTupleOrdinal(GFContext context, OlapTupleSet set) {
        return context.getIteratedTupleOrdinal(set);
    }

    public OlapScalarEntity asScalar(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "scalar");
        if (arg instanceof OlapScalarEntity) {
            return (OlapScalarEntity)arg;
        }
        return (OlapScalarEntity)this.onFunctionArgTypeMismatchError(context, argNb, "scalar", arg.getFriendlyTypeName());
    }

    @Nullable(value="if null")
    public @Nullable(value="if null") OlapDoubleVectorEntity asVector(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "scalar");
        if (arg.isMdxNull()) {
            return null;
        }
        if (arg instanceof OlapDoubleVectorEntity) {
            return (OlapDoubleVectorEntity)arg;
        }
        return (OlapDoubleVectorEntity)this.onFunctionArgTypeMismatchError(context, argNb, "vector", arg.getFriendlyTypeName());
    }

    public OlapOption toOption(GFContext context, int argNb, OlapOption ... expectedOptions) {
        OlapOption option = this.toOptionalOptionX(context, argNb, expectedOptions);
        if (option == null) {
            OlapEntity arg = this.getNonMissingArgEntity(context, argNb, Arrays.toString(expectedOptions));
            return (OlapOption)this.onFunctionArgTypeMismatchError(context, argNb, Arrays.toString(expectedOptions), arg.getFriendlyTypeName());
        }
        return option;
    }

    @Nullable
    public OlapOption toOptionalOption(GFContext context, int argNb, OlapOption ... expectedOptions) {
        if (this.isMissingArg(argNb)) {
            return null;
        }
        OlapOption option = this.toOption(context, argNb, expectedOptions);
        if (option == null) {
            OlapEntity arg = this.getNonMissingArgEntity(context, argNb, Arrays.toString(expectedOptions));
            return (OlapOption)this.onFunctionArgTypeMismatchError(context, argNb, Arrays.toString(expectedOptions), arg.getFriendlyTypeName());
        }
        return option;
    }

    @Nullable
    public OlapOption toOptionalOptionX(GFContext context, int argNb, OlapOption ... expectedOptions) {
        OlapOption option;
        if (this.isMissingArg(argNb)) {
            return null;
        }
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, Arrays.toString(expectedOptions));
        if (arg instanceof OlapOption && CdArrays.contains((Object)(option = (OlapOption)arg), (Object[])expectedOptions)) {
            return option;
        }
        return null;
    }

    public Locale toOptionalLocale(GFContext context, int argNb) {
        Locale locale = null;
        if (this.isMissingArg(argNb)) {
            locale = context.getLocale();
        } else {
            String localeAsString = this.toString(context, argNb);
            try {
                locale = LocaleUtils.toLocale((String)localeAsString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (locale == null) {
                return (Locale)this.onFunctionArgTypeMismatchError(context, argNb, "locale", this.getNonMissingArgEntity(context, argNb, "locale").getFriendlyTypeName());
            }
        }
        return locale;
    }

    public String toString(GFContext context, int argNb) {
        return this.toString(context, argNb, false);
    }

    public String toString(GFContext context, int argNb, boolean nullOnEmpty) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "string");
        if (arg instanceof OlapAbstractStringEntity) {
            return ((OlapAbstractStringEntity)arg).value();
        }
        if (arg.isToValueApplicable(context, this.evaluator)) {
            OlapScalarEntity value = context.toValue(this.evaluator, arg);
            if (value.isMdxNull()) {
                return nullOnEmpty ? null : "";
            }
            if (value instanceof OlapAbstractStringEntity) {
                return ((OlapAbstractStringEntity)value).value();
            }
            return (String)this.onFunctionArgTypeMismatchError(context, argNb, "string", value.getFriendlyTypeName());
        }
        if (arg instanceof OlapDimension) {
            return (String)this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{((OlapDimension)arg).getUniqueName(this.getNameContext(context))});
        }
        return (String)this.onFunctionArgTypeMismatchError(context, argNb, "string", arg.getFriendlyTypeName());
    }

    public boolean toOptionalBoolean(GFContext context, int argNb, boolean defaultValue) {
        if (this.isMissingArg(argNb)) {
            return defaultValue;
        }
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "boolean");
        if (arg instanceof OlapBooleanEntity) {
            return ((OlapBooleanEntity)arg).value();
        }
        return (Boolean)this.onFunctionArgTypeMismatchError(context, argNb, "boolean", arg.getFriendlyTypeName());
    }

    public OlapDateEntity toDate(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "date");
        if (arg instanceof OlapDateEntity) {
            return (OlapDateEntity)arg;
        }
        return (OlapDateEntity)this.onFunctionArgTypeMismatchError(context, argNb, "date", arg.getFriendlyTypeName());
    }

    public int toInteger(GFContext context, int argNb) {
        double asDouble;
        OlapNumericEntity num = this.toNumeric(context, argNb);
        int asInteger = num.intValue();
        if ((double)asInteger != (asDouble = num.doubleValue())) {
            return (Integer)this.onFunctionArgTypeMismatchError(context, argNb, "integer", "double", "- use the int() function to convert the value.");
        }
        return asInteger;
    }

    @Nullable
    public Integer toOptionalInteger(GFContext context, int argNb) {
        if (this.isMissingArg(argNb)) {
            return null;
        }
        return this.toInteger(context, argNb);
    }

    public double toDouble(GFContext context, int argNb) {
        OlapNumericEntity num = this.toNumeric(context, argNb);
        return num.doubleValue();
    }

    public OlapNumericEntity toNumeric(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "numeric");
        return this.toNumericX(context, argNb, arg);
    }

    public OlapNumericEntity toNumericX(GFContext context, int argNb, OlapEntity arg) {
        if (arg instanceof OlapNumericEntity) {
            return (OlapNumericEntity)arg;
        }
        if (arg.isToValueApplicable(context, this.evaluator)) {
            OlapScalarEntity value = context.toValue(this.evaluator, arg);
            if (value.isMdxNull()) {
                return OlapNumericEntity.ZERO_AS_DOUBLE;
            }
            if (value instanceof OlapNumericEntity) {
                return (OlapNumericEntity)value;
            }
            return (OlapNumericEntity)this.onFunctionArgTypeMismatchError(context, argNb, "numeric", value.getFriendlyTypeName());
        }
        if (arg instanceof OlapDimension) {
            return (OlapNumericEntity)this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{((OlapDimension)arg).getUniqueName(this.getNameContext(context))});
        }
        return (OlapNumericEntity)this.onFunctionArgTypeMismatchError(context, argNb, "numeric", arg.getFriendlyTypeName());
    }

    @Nullable(value="if argNb is not toValueApplicable")
    public @Nullable(value="if argNb is not toValueApplicable") OlapScalarEntity toValueIfApplicable(GFContext context, int argNb, String expectedType) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, expectedType);
        if (arg.isToValueApplicable(context, this.evaluator)) {
            OlapScalarEntity value = context.toValue(this.evaluator, arg);
            return value;
        }
        return null;
    }

    public OlapScalarEntity toValue(GFContext context, int argNb, String expectedType) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, expectedType);
        if (arg.isToValueApplicable(context, this.evaluator)) {
            OlapScalarEntity value = context.toValue(this.evaluator, arg);
            return value;
        }
        if (arg instanceof OlapNullEntity) {
            return OlapEmptyEntity.INSTANCE;
        }
        return (OlapScalarEntity)this.onFunctionArgTypeMismatchError(context, argNb, expectedType, arg.getFriendlyTypeName());
    }

    public OlapDoubleVectorEntity toVector(GFContext context, int argNb) {
        OlapScalarEntity arg = this.toValue(context, argNb, "vector");
        if (arg instanceof OlapDoubleVectorEntity) {
            OlapDoubleVectorEntity vectorEntity = (OlapDoubleVectorEntity)arg;
            return vectorEntity;
        }
        return (OlapDoubleVectorEntity)this.onFunctionArgTypeMismatchError(context, argNb, "vector", "vector");
    }

    public OlapMeasureGroup toMeasureGroup(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "measureGroup");
        if (arg instanceof OlapMeasureGroup) {
            OlapMeasureGroup mg = (OlapMeasureGroup)arg;
            return mg;
        }
        return (OlapMeasureGroup)this.onFunctionArgTypeMismatchError(context, argNb, "measureGroup", arg.getFriendlyTypeName());
    }

    public OlapMember toMember(GFContext context, int argNb) {
        return this.toMember(context, argNb, false);
    }

    @Nullable(value="if the member is not missing and is null")
    public @Nullable(value="if the member is not missing and is null") OlapMember toMember(GFContext context, int argNb, boolean acceptNull) {
        return this.toMember(context, argNb, acceptNull, false);
    }

    @Nullable(value="if the member is not missing and is null")
    public @Nullable(value="if the member is not missing and is null") OlapMember toMember(GFContext context, int argNb, boolean acceptNull, boolean useBaseHierIfDimension) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "member");
        if (arg.isToMemberApplicable(context.getPrepareContext())) {
            OlapMember member = arg.toNullableMember(context.getPrepareContext());
            if (member == null) {
                if (acceptNull) {
                    return null;
                }
                return (OlapMember)this.onFunctionArgNull(context, argNb, "member");
            }
            return member;
        }
        if (arg instanceof OlapDimension) {
            if (useBaseHierIfDimension) {
                return ((OlapDimension)arg).getBaseHierarchy().toNullableMember(context.getPrepareContext());
            }
            return (OlapMember)this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{((OlapDimension)arg).getUniqueName(this.getNameContext(context))});
        }
        if (arg.isMdxNull()) {
            if (acceptNull) {
                return null;
            }
            return (OlapMember)this.onFunctionArgNull(context, argNb, "member");
        }
        return (OlapMember)this.onFunctionArgTypeMismatchError(context, argNb, "member", arg.getFriendlyTypeName());
    }

    @Nullable(value="if argNb is not toMemberApplicable")
    public @Nullable(value="if argNb is not toMemberApplicable") OlapMember toMemberIfApplicable(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "member");
        if (arg.isToMemberApplicable(context.getPrepareContext())) {
            OlapMember member = arg.toNullableMember(context.getPrepareContext());
            if (member == null) {
                return (OlapMember)this.onFunctionArgNull(context, argNb, "member");
            }
            return member;
        }
        return null;
    }

    public OlapTuple toTuple(GFContext context, int argNb) {
        return this.toTuple(context, argNb, false);
    }

    @Nullable(value="if the tuple is not missing and is null or filtered out (e.g., hierarchy-2-tuple)")
    public @Nullable(value="if the tuple is not missing and is null or filtered out (e.g., hierarchy-2-tuple)") OlapTuple toTuple(GFContext context, int argNb, boolean acceptNull) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "tuple");
        if (arg.isToTupleApplicable(context.getPrepareContext())) {
            OlapTuple tuple = arg.toTuple(context.getPrepareContext());
            if (tuple.isFilteredOut()) {
                return null;
            }
            return tuple;
        }
        if (arg instanceof OlapDimension) {
            return (OlapTuple)this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{((OlapDimension)arg).getUniqueName(this.getNameContext(context))});
        }
        if (arg.isMdxNull()) {
            if (acceptNull) {
                return null;
            }
            return (OlapTuple)this.onFunctionArgNull(context, argNb, "tuple");
        }
        return (OlapTuple)this.onFunctionArgTypeMismatchError(context, argNb, "tuple", arg.getFriendlyTypeName());
    }

    @Nullable(value="if argNb is not toTupleApplicable")
    public @Nullable(value="if argNb is not toTupleApplicable") OlapTuple toTupleOptionalIfApplicable(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "tuple");
        if (arg.isToTupleApplicable(context.getPrepareContext())) {
            OlapTuple tuple = arg.toTuple(context.getPrepareContext());
            return tuple;
        }
        return null;
    }

    public OlapSubCubeEntity toSubCube(GFContext context, int argNb, String expectedType) {
        OlapEntity entity = this.getNonMissingArgEntity(context, argNb, expectedType);
        if (!(entity instanceof OlapSubCubeEntity)) {
            return (OlapSubCubeEntity)this.onFunctionArgTypeMismatchError(context, argNb, expectedType, entity.getFriendlyTypeName());
        }
        OlapSubCubeEntity subCubeEntity = (OlapSubCubeEntity)entity;
        return subCubeEntity;
    }

    public OlapTupleSet<? extends OlapTuple> toSet(GFContext context, int argNb) {
        return this.toSet(context, argNb, false);
    }

    @Nullable(value="if the set is not missing and is null")
    public @Nullable(value="if the set is not missing and is null") OlapTupleSet<? extends OlapTuple> toSet(GFContext context, int argNb, boolean acceptNull) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "set");
        if (arg.isToSetApplicable(context.getPrepareContext())) {
            OlapTupleSet<? extends OlapTuple> toSet = arg.toSet(context.getPrepareContext());
            OlapSlicerFilter slicerTupleFilter = this.getSlicerTupleFilterForSetFiltering(context);
            return OlapSetFactory.instance(slicerTupleFilter, toSet);
        }
        if (arg instanceof OlapDimension) {
            return (OlapTupleSet)this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{((OlapDimension)arg).getUniqueName(this.getNameContext(context))});
        }
        if (arg.isMdxNull()) {
            if (acceptNull) {
                return null;
            }
            return (OlapTupleSet)this.onFunctionArgNull(context, argNb, "set");
        }
        return (OlapTupleSet)this.onFunctionArgTypeMismatchError(context, argNb, "set", arg.getFriendlyTypeName());
    }

    @Nullable(value="if argNb is not toSetApplicable")
    public @Nullable(value="if argNb is not toSetApplicable") OlapTupleSet<? extends OlapTuple> toSetIfApplicable(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "set");
        if (arg.isToSetApplicable(context.getPrepareContext())) {
            OlapTupleSet<? extends OlapTuple> toSet = arg.toSet(context.getPrepareContext());
            OlapSlicerFilter slicerTupleFilter = this.getSlicerTupleFilterForSetFiltering(context);
            return OlapSetFactory.instance(slicerTupleFilter, toSet);
        }
        return null;
    }

    @Nullable(value="if the set is not missing and is null")
    public @Nullable(value="if the set is not missing and is null") OlapTupleSet<OlapMember> toMemberSet(GFContext context, int argNb, boolean acceptNull) {
        OlapTupleSet<? extends OlapTuple> set = this.toSet(context, argNb, acceptNull);
        if (set == null) {
            if (!acceptNull) {
                throw new CdProgrammingException();
            }
            return null;
        }
        OlapTupleSet<OlapMember> members = set.asMemberSet();
        if (members == null) {
            return (OlapTupleSet)this.onFunctionArgTypeMismatchError(context, argNb, "set(member)", "set");
        }
        return members;
    }

    @Nullable(value="if entity is not toMemberApplicable")
    public @Nullable(value="if entity is not toMemberApplicable") OlapTupleSet toNameSetIfApplicable(GFContext context, OlapEntity entity) {
        if (entity.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        if (entity.isToMemberApplicable(context.getPrepareContext())) {
            OlapMember member = entity.toNullableMember(context.getPrepareContext());
            return OlapSetFactory.singleton(member);
        }
        return null;
    }

    public OlapHierarchy toHierarchy(GFContext context, int argNb, boolean acceptNull) {
        OlapEntity entity = this.getNonMissingArgEntity(context, argNb, "hierarchy");
        return this.toHierarchy(context, argNb, entity, acceptNull);
    }

    public OlapDimension toDimension(GFContext context, int argNb, boolean acceptNull) {
        OlapEntity entity = this.getNonMissingArgEntity(context, argNb, "dimension");
        if (acceptNull && entity.isMdxNull()) {
            return null;
        }
        if (entity instanceof OlapHierarchy) {
            return ((OlapHierarchy)entity).getDimension();
        }
        if (entity instanceof OlapDimension) {
            return (OlapDimension)entity;
        }
        if (entity instanceof OlapLevel) {
            return ((OlapLevel)entity).getDimension();
        }
        if (entity instanceof OlapMember) {
            return ((OlapMember)entity).getDimension();
        }
        return (OlapDimension)this.onFunctionArgTypeMismatchError(context, argNb, "dimension", entity.getFriendlyTypeName());
    }

    public OlapHierarchy toHierarchy(GFContext context, int argNb, OlapEntity entity, boolean acceptNull) {
        if (acceptNull && entity.isMdxNull()) {
            return null;
        }
        if (entity instanceof OlapHierarchy) {
            return (OlapHierarchy)entity;
        }
        return (OlapHierarchy)this.onFunctionArgTypeMismatchError(context, argNb, "hierarchy", entity.getFriendlyTypeName());
    }

    public OlapHierarchy toOnlyHierarchy(GFContext context, int argNb, OlapDimension dimension) {
        int hierarchyCount = dimension.getHierarchyCount(this.getDimensionsPermissions(context));
        if (hierarchyCount == 0) {
            return (OlapHierarchy)this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_DIMENSION_WITH_NO_HIERARCHY, new Serializable[]{dimension.getUniqueName(this.getNameContext(context))});
        }
        if (hierarchyCount > 1) {
            return (OlapHierarchy)this.onFunctionError(context, argNb, OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{dimension.getUniqueName(this.getNameContext(context))});
        }
        return dimension.getSingleHierarchy(this.getDimensionsPermissions(context));
    }

    public OlapHierarchy toHierarchyX(GFContext context, int argNb, boolean acceptNull) {
        OlapEntity entity = this.getNonMissingArgEntity(context, argNb, "hierarchy|dimension");
        OlapHierarchy hierarchy = entity instanceof OlapDimension ? this.toOnlyHierarchy(context, argNb, (OlapDimension)entity) : this.toHierarchy(context, argNb, entity, acceptNull);
        return hierarchy;
    }

    public OlapLevel toLevel(GFContext context, int argNb) {
        OlapEntity arg = this.getNonMissingArgEntity(context, argNb, "level");
        if (arg instanceof OlapLevel) {
            return (OlapLevel)arg;
        }
        return (OlapLevel)this.onFunctionArgTypeMismatchError(context, argNb, "level", arg.getFriendlyTypeName());
    }

    public String toMdxStringExpression(GFContext context, int argNb) {
        if (this.isMissingArg(argNb) || this.getNonMissingArgEntity(context, argNb, "string").isMdxNull()) {
            return (String)this.onFunctionError(context, argNb, OlapErrorCode.MDX_EXPRESSION_EXPECTED, new Serializable[0]);
        }
        return this.toString(context, argNb);
    }

    public OlapScalarEntity isEmptyValue(GFContext context, OlapTuple tuple) {
        OlapScalarEntity isEmpty = context.isEmptyValue(this.evaluator, tuple);
        return isEmpty;
    }

    public void addVisualTotalsCluster(GFContext context, OlapVisualTotalsCluster cluster) {
        context.addVisualTotalsCluster(cluster);
    }

    public void doNotUseResultCache(GFContext context) {
        context.doNotUseResultCache();
    }

    public void markForDrilldownStop(GFContext context) {
        context.markForDrilldownStop();
    }

    public OlapEntityIdentifier compileIdentifier(GFContext context, String name) throws CdMdxScannerException, MdxParserException {
        return context.compileIdentifier(name);
    }

    public OlapTuple completeTupleForElementValue(GFContext context, OlapTuple tupleToComplete) {
        return context.completeTupleForElementValue(tupleToComplete);
    }

    public void pushFactsSubCube(GFContext context, S_RequestSubCubeDef factsSubCube) {
        context.pushFactsSubCube(factsSubCube);
    }

    public void popFactsSubCube(GFContext context, S_RequestSubCubeDef factsSubCube) {
        context.popFactsSubCube(factsSubCube);
    }

    public void addStatementCachedObject(GFContext context, OlapFormatterKey key, OlapFormatter formatter) {
        context.addStatementCachedObject(key, formatter);
    }

    @Nullable
    public Object getStatementCachedObject(GFContext context, OlapFormatterKey key) {
        return context.getStatementCachedObject(key);
    }

    @Nullable
    public OlapMember getAggregationTypeMember(GFContext context) {
        return context.getAggregationTypeMember();
    }

    public final OlapEntity executeNameToSetMdxExpression(GFContext context, OlapFunction function, int argumentIndex, String mdx, String mdxHash) throws OlapEvaluationException {
        return context.executeNameToSetMdxExpression(this.evaluator, this, function, argumentIndex, mdx, mdxHash);
    }

    public final <T> T executeStrToMdxExpression(GFContext context, boolean constrained, OlapFunction function, int argumentIndex, String mdx, String mdxHash, IGFStrToFunctionCallback<T> callback) throws OlapEvaluationException {
        return context.executeStrToMdxExpression(this.evaluator, constrained, this, function, argumentIndex, mdx, mdxHash, callback);
    }

    public S_RequestSubCubeDef getOrCreateFactsSubCube(GFContext context, OlapSubCubeEntity entity) {
        S_RequestSubCubeDef subCubeDef = context.getOrCreateFactsSubCube(entity);
        return subCubeDef;
    }
}

