/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel;

import crazydev.iccube.collection.IOlapIterator;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaTask;
import crazydev.iccube.olap.eval.facts.cells.IOlapFactsCellEvaluationTask;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellEvaluationTaskFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class GFParallelLambdaTaskFactory
extends OlapFactsCellEvaluationTaskFactory {
    private final GFParallelLambdaContext context;
    private final long batchSize;
    private IOlapIterator<? extends OlapTuple> tuples;
    private int iTupleOrdinal;
    private boolean done;

    public GFParallelLambdaTaskFactory(GFParallelLambdaContext context) {
        super(context.getStatementExecutionContext());
        this.context = context;
        this.batchSize = context.getBatchSize();
    }

    @Override
    public OlapThreadPoolExecutorTaskSchedulingPolicy getSchedulingPolicy() {
        return OlapThreadPoolExecutorTaskSchedulingPolicy.NONE;
    }

    @Override
    public void init() {
        super.init();
        if (OlapLoggers.MDX_EVALUATION_LAMBDA.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION_LAMBDA.debug((Object)("[mdx] parallel lambda processing started [batch:" + this.batchSize + "]"));
        }
        OlapTupleSet set = this.context.getIteratedSet();
        this.tuples = set.getIterator(false);
        this.tuples.reset();
        this.iTupleOrdinal = 1;
        this.done = false;
    }

    @Override
    @Nullable
    protected IOlapFactsCellEvaluationTask nextTask() {
        OlapTuple iTuple;
        if (this.done) {
            return null;
        }
        ArrayList<OlapTuple> buffer = new ArrayList<OlapTuple>();
        int bufferOrdinal = this.iTupleOrdinal;
        while ((iTuple = this.tuples.next()) != null) {
            ++this.iTupleOrdinal;
            buffer.add(iTuple);
            if ((long)buffer.size() < this.batchSize) continue;
        }
        if (!buffer.isEmpty() && this.context.stopIterationOrdinal() == -1) {
            return new GFParallelLambdaTask(this.context, buffer, bufferOrdinal);
        }
        if (OlapLoggers.MDX_EVALUATION_LAMBDA.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION_LAMBDA.debug((Object)("[mdx] parallel lambda processing set iteration done ( " + (this.iTupleOrdinal - 1) + " )"));
        }
        this.done = true;
        return null;
    }

    @Override
    public void done() {
        super.done();
    }
}

