/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFCellsExecutor;
import crazydev.iccube.olap.eval.facts.cells.processor.IOlapCellProcessor;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellMeasureVectorsPositions;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellProcessorFactory;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.select.OlapSelectInstr;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFRegularCellsExecutor
extends GFCellsExecutor {
    public GFRegularCellsExecutor(OlapSelectStatementExecutionContext sContext, OlapMdxExecutionPermit permit, OlapSelectInstr selectInstr, boolean isEvalOrdinalOnly, boolean[] hasNonEmpties, OlapTupleSet<OlapTuple>[] axesAsSets, List<OlapCellProperty> requestedCellProperties) {
        super(sContext, permit, selectInstr, isEvalOrdinalOnly, hasNonEmpties, axesAsSets, requestedCellProperties);
    }

    @Override
    @Nullable
    protected IOlapCombinationIterator<OlapTuple> setupCellsIterator(IOlapEvalResult result) {
        boolean forTidyEvaluation = result.isForTidyEvaluation();
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] setup cells iterator [tidy:" + forTidyEvaluation + "]"));
        IOlapCellProcessor processor = OlapCellProcessorFactory.create(this.sContext, forTidyEvaluation, this.isEvalOrdinalOnly, this.axesAsSets, this.hasNonEmpties, this.isNonEmptyActive);
        IOlapCombinationIterator<OlapTuple> cellTuples = processor.process(result);
        if (result.isForTidyEvaluation()) {
            return cellTuples;
        }
        cellTuples.reset();
        OlapTuple[] cellTuple = cellTuples.next();
        if (cellTuple == null) {
            return null;
        }
        int[] Si = cellTuples.Si();
        if (GFRegularCellsExecutor.isEmptyCombinations(Si)) {
            OlapCellMeasureVectorsPositions measureVectorsPositions = this.sContext.getMeasureVectorsPositions();
            int axisCount = cellTuples.axisCount();
            for (int axis = 0; axis < axisCount; ++axis) {
                List<OlapTuple> axisTuples = cellTuples.extractAxis(axis);
                if (measureVectorsPositions != null) {
                    axisTuples = measureVectorsPositions.adjustAxisTuples(axisTuples);
                }
                result.addAxisTuples(axis, axisTuples);
            }
            return null;
        }
        this.selectInstr.assertHierarchyUsage(this.sContext, cellTuple);
        return cellTuples;
    }

    public static boolean isEmptyCombinations(int[] Si) {
        for (int si : Si) {
            if (si != -1) continue;
            return true;
        }
        return false;
    }
}

