/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.facts.cells.IOlapFactsCellEvaluationTask;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellEvaluationTaskFactory;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import org.jetbrains.annotations.Nullable;

public abstract class GFCellTaskFactory
extends OlapFactsCellEvaluationTaskFactory {
    private final OlapCellsEvaluationContext cellsEvalContext;
    private final IOlapEvalResult result;
    private final IOlapCombinationIterator<OlapTuple> cells;
    private OlapTuple[] nextCellTuples;
    private boolean first;

    protected GFCellTaskFactory(OlapCellsEvaluationContext cellsEvalContext, IOlapEvalResult result, IOlapCombinationIterator<OlapTuple> cells) {
        super(cellsEvalContext.getStatementContext());
        this.cellsEvalContext = cellsEvalContext;
        this.result = result;
        this.cells = cells;
    }

    @Override
    public void init() {
        super.init();
        this.cells.reset();
        this.nextCellTuples = this.cells.next();
        this.first = true;
    }

    @Override
    @Nullable
    protected IOlapFactsCellEvaluationTask nextTask() {
        if (this.nextCellTuples == null) {
            return null;
        }
        int rowIndex = this.cells.rowIndex();
        OlapEvalResultSi cellSi = GFCellTaskFactory.cloneCellSi(this.cells.Si());
        OlapTuple[] cellTuples = GFCellTaskFactory.cloneCellTuple(this.nextCellTuples);
        this.nextCellTuples = this.cells.next();
        if (this.first) {
            if (this.nextCellTuples != null) {
                OlapSelectStatementExecutionContext sContext = this.cellsEvalContext.getStatementContext();
                sContext.onMultiCellsEvaluationStarted();
            }
            this.first = false;
        }
        IOlapFactsCellEvaluationTask task = this.createNextTask(this.cellsEvalContext, this.result, this.cells, rowIndex, cellSi, cellTuples);
        return task;
    }

    protected abstract IOlapFactsCellEvaluationTask createNextTask(OlapCellsEvaluationContext var1, IOlapEvalResult var2, IOlapCombinationIterator<OlapTuple> var3, int var4, OlapEvalResultSi var5, OlapTuple[] var6);

    private static OlapEvalResultSi cloneCellSi(int[] si) {
        return new OlapEvalResultSi((int[])si.clone());
    }

    private static OlapTuple[] cloneCellTuple(OlapTuple[] cellTuples) {
        OlapTuple[] clone = new OlapTuple[cellTuples.length];
        System.arraycopy(cellTuples, 0, clone, 0, cellTuples.length);
        return clone;
    }
}

