/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.scalar.OlapErrorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.util.List;

public abstract class GFCellPropertiesHelper {
    public static OlapScalarEntity[] evalRequestedCellProperties(GFCellPropertyEvalContext context) {
        OlapInstrExecListener listener = context.getInstrExecListener();
        if (listener != null) {
            listener.beginCellProperties();
        }
        OlapScalarEntity[] res = GFCellPropertiesHelper.doEvalRequestedCellProperties(context);
        if (listener != null) {
            listener.endCellProperties();
        }
        return res;
    }

    private static OlapScalarEntity[] doEvalRequestedCellProperties(GFCellPropertyEvalContext context) {
        List<OlapCellProperty> requestedCellProperties = context.getRequestedCellProperties();
        int propertyCount = requestedCellProperties.size();
        OlapScalarEntity[] pvalues = new OlapScalarEntity[propertyCount];
        OlapTuple cellTuple = context.getCellTuple();
        if (cellTuple.isOK()) {
            for (int idx = 0; idx < propertyCount; ++idx) {
                OlapCellProperty property = requestedCellProperties.get(idx);
                context.clearReferences();
                try {
                    OlapScalarEntity cellValue;
                    OlapMdxStatementExecutionContext scontext = context.getStatementExecutionContext();
                    if (!scontext.isOnAxes()) {
                        cellValue = context.getCellValueAsScalar();
                        pvalues[idx] = property.eval(context, cellValue);
                        continue;
                    }
                    if (!property.isCellOrdinal() && !property.isValue()) continue;
                    cellValue = context.getCellValueAsScalar();
                    pvalues[idx] = property.eval(context, cellValue);
                    continue;
                }
                catch (OlapEvaluationException ex) {
                    pvalues[idx] = new OlapErrorEntity(ex);
                }
            }
        }
        return pvalues;
    }
}

