/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context.factcache;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.cache.GFCacheUtils;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class GFAbstractFactsTupleCache {
    private final OlapSelectStatementExecutionContext sContext;
    @Nullable
    private final OlapInstrExecListener listener;
    private final int limit;
    private final Map<GFFactsEvalTuple, OlapScalarEntity> evalCache;
    private final AtomicLong get = new AtomicLong();
    private final AtomicLong miss = new AtomicLong();

    public GFAbstractFactsTupleCache(OlapSelectStatementExecutionContext sContext) {
        this.sContext = sContext;
        this.listener = sContext.getInstrExecListener();
        this.limit = sContext.getRequestProperties().getMdxQueryCacheMax();
        this.evalCache = this.createMap();
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] create facts cache [ " + this.limit + " ]"));
    }

    protected abstract Map<GFFactsEvalTuple, OlapScalarEntity> createMap();

    public void onCellValuesProcessed(OlapSelectStatementExecutionContext sContext) {
        OlapMdxStatementEvalStatistics stats = sContext.getEvalStatistics();
        stats.onCellsCached(this.evalCache.size(), this.get.get(), this.miss.get());
    }

    public void clearCache() {
        this.get.set(0L);
        this.miss.set(0L);
        this.evalCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapScalarEntity getFromCache(GFContext context, GFFactsEvalTuple evalTuple, Supplier<OlapScalarEntity> tupleCalc) {
        OlapScalarEntity value;
        this.get.incrementAndGet();
        MutableBoolean computed = new MutableBoolean();
        if (this.evalCache.size() < this.limit) {
            value = this.evalCache.computeIfAbsent(evalTuple, tuple -> {
                computed.value = true;
                OlapScalarEntity res = this.computeValueFromFacts(tupleCalc);
                res = res.asConstant();
                return res;
            });
        } else {
            OlapScalarEntity cValue = this.evalCache.get(evalTuple);
            if (cValue == null) {
                computed.value = true;
                value = this.computeValueFromFacts(tupleCalc);
            } else {
                value = cValue;
            }
        }
        if (!computed.value) {
            if (this.listener != null) {
                this.listener.onCachedTupleValue();
            }
            if (GFCacheUtils.ASSERT_CONSISTENCY) {
                context.freezeStats();
                try {
                    OlapScalarEntity computedValue = this.computeValueFromFacts(tupleCalc);
                    GFCacheUtils.assertCachedValue(evalTuple, value, computedValue);
                    this.miss.decrementAndGet();
                }
                finally {
                    context.unfreezeStats();
                }
            }
        }
        return value;
    }

    private OlapScalarEntity computeValueFromFacts(Supplier<OlapScalarEntity> tupleCalc) {
        this.miss.incrementAndGet();
        OlapScalarEntity value = tupleCalc.get();
        return value;
    }

    private static class MutableBoolean {
        private boolean value = false;

        private MutableBoolean() {
        }
    }
}

