/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context;

import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellsTupleEvaluator;
import crazydev.iccube.olap.eval.select.context.OlapCellEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFCellEvalContext
extends GFContext {
    private final GFCellsTupleEvaluator cellsTupleEvaluator;
    private final OlapCellEvaluationContext evalContext;
    private final OlapTuple cellTuple;
    @Nullable
    private OlapMember cellMeasure;
    private int cellMeasureVectorPos;

    public GFCellEvalContext(GFCellsTupleEvaluator cellsTupleEvaluator, OlapCellEvaluationContext evalContext, OlapTuple cellTuple) {
        super(evalContext);
        this.cellsTupleEvaluator = cellsTupleEvaluator;
        this.evalContext = evalContext;
        this.cellTuple = cellTuple;
        this.cellMeasure = null;
        this.cellMeasureVectorPos = -1;
    }

    public OlapSelectStatementExecutionContext getStatementContext() {
        return this.evalContext.getStatementContext();
    }

    public GFCellsTupleEvaluator getCellsTupleEvaluator() {
        return this.cellsTupleEvaluator;
    }

    public boolean isNonEmptyActive() {
        return this.evalContext.isNonEmptyActive();
    }

    public List<OlapCellProperty> getRequestedCellProperties() {
        return this.evalContext.getRequestedCellProperties();
    }

    public OlapTuple getCellTuple() {
        return this.cellTuple;
    }

    @Nullable
    public OlapMember getCellMeasure() {
        if (this.cellMeasure instanceof OlapMeasureVectorMember && this.cellMeasureVectorPos != -1) {
            OlapMeasureVectorMember vector = (OlapMeasureVectorMember)this.cellMeasure;
            List<OlapMeasureMember> measures = vector.getMeasures();
            return measures.get(this.cellMeasureVectorPos);
        }
        return this.cellMeasure;
    }

    @Override
    public void setCellMeasure(OlapMember cellMeasure) {
        OlapMember cm = this.cellMeasure;
        if (!(cm == null || OlapMember.equal(cm, cellMeasure) && cm.isCalculated())) {
            throw new RuntimeException("internal error : inconsistent cell-measure setup (new : " + String.valueOf(cellMeasure) + ") (was : " + String.valueOf(cm) + ")");
        }
        this.cellMeasure = cellMeasure;
    }

    public void setupCellMeasureVectorPos(int pos) {
        this.cellMeasureVectorPos = pos;
    }

    public int getCellMeasureVectorPos() {
        return this.cellMeasureVectorPos;
    }

    @Override
    protected GFContext doForkForParallelLambdaProcessing(OlapEvaluationContext evalContextF) {
        return new GFCellEvalContext(this.cellsTupleEvaluator, (OlapCellEvaluationContext)evalContextF, this.cellTuple);
    }
}

