/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapInvalidTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFTupleNode;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.tuple.OlapTupleOrParenInstr;
import org.jetbrains.annotations.Nullable;

public class OlapTuplePreparedInstr
extends OlapPreparedInstr<OlapInstr> {
    private final OlapTuple tuple;

    public OlapTuplePreparedInstr(OlapIdentifierInstr instr, OlapTuple tuple) {
        super(instr);
        this.tuple = tuple;
    }

    public OlapTuplePreparedInstr(OlapTupleOrParenInstr instr, IOlapPrepareContext context, OlapPreparedInstr[] memberInstrs) {
        super(instr);
        OlapMember[] members = new OlapMember[memberInstrs.length];
        for (int ii = 0; ii < members.length; ++ii) {
            members[ii] = memberInstrs[ii].toQuickNullableMember(context);
            if (members[ii] != null) continue;
            this.tuple = OlapInvalidTuple.INSTANCE;
            return;
        }
        OlapTupleDimensionalityCache cache = context.getTupleDimensionalityCache();
        this.tuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, cache, members);
    }

    public OlapTuple getTuple() {
        return this.tuple;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public OlapMember toQuickNullableMember(IOlapPrepareContext context) {
        if (this.tuple.getMemberCount() != 1) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        return this.tuple.getMember(0);
    }

    @Override
    public boolean isQuickToMemberApplicable(IOlapPrepareContext context) {
        return this.tuple.getMemberCount() == 1;
    }

    @Override
    public boolean isQuickToTupleApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public OlapTuple toQuickTuple(IOlapPrepareContext context) {
        return this.tuple;
    }

    @Override
    public boolean isQuickToListSetApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public OlapListTupleSet toQuickListSet(IOlapPrepareContext context) {
        OlapTupleSet<? extends OlapTuple> asSet = this.tuple.toSet(context);
        if (asSet instanceof OlapListTupleSet) {
            return (OlapListTupleSet)asSet;
        }
        throw new RuntimeException("internal error: inconsistent tuple-quick-set conversion");
    }

    @Override
    @Nullable
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation) {
        return new GFTupleNode(markedForValueEvaluation, this.instr, this.tuple);
    }
}

