/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.iccube.configuration.component.properties.OlapFilterProcessingMode;
import crazydev.iccube.olap.eval.execinstr.OlapLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallbackFactory;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIteratorApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import org.jetbrains.annotations.Nullable;

public class OlapIteratorApplyLambdaPreparedInstr
extends OlapPreparedInstr<OlapFunctionCallInstr> {
    private final OlapFilterProcessingMode mode;
    private final GFApplyLambdaCallbackFactory callbackFactory;
    protected final boolean nonEmptyFunction;
    protected final OlapInstr[] functionCallArgInstrs;
    protected final OlapFunction function;
    protected final OlapPreparedInstr[] instrs;
    protected final int limitFromContext;

    public OlapIteratorApplyLambdaPreparedInstr(OlapFilterProcessingMode mode, GFApplyLambdaCallbackFactory callbackFactory, boolean nonEmptyFunction, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, OlapPreparedInstr[] instrs, int limitFromContext) {
        super(functionCallInstr);
        this.mode = mode;
        this.callbackFactory = callbackFactory;
        this.nonEmptyFunction = nonEmptyFunction;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.instrs = instrs;
        this.limitFromContext = limitFromContext;
    }

    @Override
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation) {
        GFNode set = this.instrs[0].buildGFTree(context, false);
        GFNode lambda = this.getLambda(context, 1);
        GFNode[] args = new GFNode[this.instrs.length];
        args[0] = set;
        if (lambda != null) {
            args[1] = lambda;
            for (int i = 2; i < this.instrs.length; ++i) {
                args[i] = this.instrs[i].buildGFTree(context, false);
            }
        }
        return new GFIteratorApplyLambdaNode(this.mode, this.callbackFactory, this.nonEmptyFunction, markedForValueEvaluation, (OlapFunctionCallInstr)this.instr, this.functionCallArgInstrs, this.function, args, set, lambda, this.limitFromContext);
    }

    @Nullable
    protected GFNode getLambda(GFNodeBuildContext context, int pos) {
        if (this.instrs.length > pos) {
            OlapPreparedInstr lambdaInstr = this.instrs[pos];
            boolean lambdaMarkedForValueEvaluation = lambdaInstr instanceof OlapLambdaPreparedInstr && ((OlapLambdaPreparedInstr)lambdaInstr).getExpr().isTupleOrLiteral();
            return lambdaInstr.buildGFTree(context, lambdaMarkedForValueEvaluation);
        }
        if (this.nonEmptyFunction) {
            return null;
        }
        throw new RuntimeException("internal error : unexpected missing lambda expression [" + pos + "]");
    }
}

