/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstrTypeContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFBinaryOperatorAndNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFBinaryOperatorNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFBinaryOperatorOrNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.operator.binary.OlapBaseBinaryOperator;
import crazydev.iccube.olap.eval.operator.binary.OlapBinaryOperator;
import crazydev.iccube.olap.eval.operator.binary.OlapBinaryOperatorCallInstr;
import crazydev.iccube.olap.eval.operator.common.OlapOperatorName;

public class OlapBinaryOperatorPreparedInstr
extends OlapPreparedInstr {
    private final OlapBinaryOperator operator;
    private final OlapPreparedInstr left;
    private final OlapPreparedInstr right;

    public OlapBinaryOperatorPreparedInstr(OlapBinaryOperatorCallInstr instr, OlapBinaryOperator operator, OlapPreparedInstr left, OlapPreparedInstr right) {
        super(instr);
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean isScalar(OlapPreparedInstrTypeContext ctxt) {
        if (this.operator.isAlwaysScalar()) {
            return true;
        }
        if (this.operator.isPossiblyScalar()) {
            boolean isLeftToValue = this.left.isScalar(ctxt);
            boolean isRightToValue = this.right.isScalar(ctxt);
            return isLeftToValue && isRightToValue;
        }
        return false;
    }

    @Override
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation) {
        boolean markedForValueEvaluationL = false;
        boolean markedForValueEvaluationR = false;
        if (this.operator instanceof OlapBaseBinaryOperator) {
            OlapPreparedInstrTypeContext ctxt = new OlapPreparedInstrTypeContext();
            boolean isLeftToValue = this.left.isScalar(ctxt);
            boolean isRightToValue = this.right.isScalar(ctxt);
            if (isLeftToValue && isRightToValue) {
                if (!this.left.isNullLiteral()) {
                    markedForValueEvaluationL = true;
                }
                if (!this.right.isNullLiteral()) {
                    markedForValueEvaluationR = true;
                }
            }
        }
        GFNode leftT = this.left.buildGFTree(context, markedForValueEvaluationL);
        GFNode rightT = this.right.buildGFTree(context, markedForValueEvaluationR);
        OlapOperatorName op = this.operator.getName();
        if (op == OlapOperatorName.OR) {
            return new GFBinaryOperatorOrNode(markedForValueEvaluation, this.instr, this.operator, leftT, rightT);
        }
        if (op == OlapOperatorName.AND) {
            return new GFBinaryOperatorAndNode(markedForValueEvaluation, this.instr, this.operator, leftT, rightT);
        }
        return new GFBinaryOperatorNode(markedForValueEvaluation, this.instr, this.operator, leftT, rightT);
    }
}

