/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.evaluator;

import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorConfiguration;
import crazydev.iccube.olap.eval.evaluator.monitoring.OlapMdxExecutorMonitoring;
import crazydev.iccube.olap.eval.extra.OlapMdxExtraExecutor;
import crazydev.iccube.olap.eval.facts.cells.OlapMdxCellExecutor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OlapMdxExecutorsPool {
    private final OlapMdxExecutorMonitoring monitoring;
    private final Map<OlapMdxExecutorConfiguration, LinkedList<OlapMdxCellExecutor>> cellExecutors = new HashMap<OlapMdxExecutorConfiguration, LinkedList<OlapMdxCellExecutor>>();
    private final Map<OlapMdxExecutorConfiguration, LinkedList<OlapMdxExtraExecutor>> extraExecutors = new HashMap<OlapMdxExecutorConfiguration, LinkedList<OlapMdxExtraExecutor>>();

    public OlapMdxExecutorsPool(OlapMdxExecutorMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public void shutdownNowCellExecutors() {
        for (List list : this.cellExecutors.values()) {
            for (OlapMdxCellExecutor executor : list) {
                executor.shutdownNow();
            }
        }
    }

    public void shutdownNowExtraExecutors() {
        for (List list : this.extraExecutors.values()) {
            for (OlapMdxExtraExecutor executor : list) {
                executor.shutdownNow();
            }
        }
    }

    public OlapMdxCellExecutor getOrCreateCellExecutor(OlapEngineMdxEvalProfile profile) {
        OlapMdxCellExecutor executor;
        OlapMdxExecutorConfiguration configuration = new OlapMdxExecutorConfiguration(profile.getCellThreadCount(), profile.getCellQueueSize());
        LinkedList<OlapMdxCellExecutor> executors = this.cellExecutors.get(configuration);
        if (executors == null || executors.isEmpty()) {
            executor = new OlapMdxCellExecutor(configuration);
            this.monitoring.onCreateCellExecutor(profile, executor);
        } else {
            executor = executors.pop();
        }
        return executor;
    }

    public void releaseCellExecutor(OlapMdxCellExecutor executor) {
        OlapMdxExecutorConfiguration configuration = executor.getConfiguration();
        LinkedList<OlapMdxCellExecutor> executors = this.cellExecutors.get(configuration);
        if (executors == null) {
            executors = new LinkedList();
            this.cellExecutors.put(configuration, executors);
        }
        executors.push(executor);
        this.monitoring.onDeleteCellExecutor(executor);
    }

    public OlapMdxExtraExecutor getOrCreateExtraExecutor(OlapEngineMdxEvalProfile profile) {
        OlapMdxExtraExecutor executor;
        OlapMdxExecutorConfiguration configuration = new OlapMdxExecutorConfiguration(profile.getExtraThreadCount(), profile.getExtraQueueSize());
        LinkedList<OlapMdxExtraExecutor> executors = this.extraExecutors.get(configuration);
        if (executors == null || executors.isEmpty()) {
            executor = new OlapMdxExtraExecutor(configuration);
            this.monitoring.onCreateExtraExecutor(profile, executor);
        } else {
            executor = executors.pop();
        }
        return executor;
    }

    public void releaseExtraExecutor(OlapMdxExtraExecutor executor) {
        OlapMdxExecutorConfiguration configuration = executor.getConfiguration();
        LinkedList<OlapMdxExtraExecutor> executors = this.extraExecutors.get(configuration);
        if (executors == null) {
            executors = new LinkedList();
            this.extraExecutors.put(configuration, executors);
        }
        executors.push(executor);
        this.monitoring.onDeleteExtraExecutor(executor);
    }
}

