/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.evaluator;

import crazydev.iccube.common.IOlapContext;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalConfiguration;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileMonitoringMode;
import crazydev.iccube.olap.eval.evaluator.OlapMdxCellExecutorReference;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsContainer;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExtraExecutorReference;
import crazydev.iccube.olap.eval.evaluator.monitoring.OlapMdxExecutorMonitoring;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestTracker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class OlapMdxExecutorsManager {
    protected final OlapEngineMdxEvalProfileMonitoringMode monitoringMode;
    protected final OlapMdxExecutorMonitoring monitoring;
    private final OlapEngineMdxEvalConfiguration configuration;
    private final Semaphore globalActiveMdxCount;
    private final Map<OlapEngineMdxEvalProfile, Semaphore> profileActiveMdxCounts = new HashMap<OlapEngineMdxEvalProfile, Semaphore>();
    private final OlapMdxExecutorsContainer executors;

    public OlapMdxExecutorsManager(boolean simultaneousMdxQueryLicensed, boolean multithreadedMdxQueryLicensed, OlapEngineMdxEvalConfiguration configuration) {
        this.configuration = configuration;
        this.monitoringMode = configuration.getMonitoringMode() != null ? configuration.getMonitoringMode() : OlapEngineMdxEvalProfileMonitoringMode.NONE;
        this.monitoring = OlapMdxExecutorMonitoring.create(this.monitoringMode);
        if (simultaneousMdxQueryLicensed) {
            this.globalActiveMdxCount = new Semaphore(configuration.getActiveMdxRequestCount());
            List<OlapEngineMdxEvalProfile> profiles = configuration.getProfiles();
            for (OlapEngineMdxEvalProfile profile : profiles) {
                int count = profile.getActiveMdxRequestCount();
                if (count < 1) continue;
                this.profileActiveMdxCounts.put(profile, new Semaphore(count));
            }
        } else {
            this.globalActiveMdxCount = new Semaphore(1);
        }
        this.executors = new OlapMdxExecutorsContainer(configuration, this.monitoring);
    }

    public void shutdownNow() {
        this.executors.shutdownNow();
    }

    public OlapMdxExecutorMonitoring getMonitoring() {
        return this.executors.getMonitoring();
    }

    public long getQueuedTaskCountForServerDefaultProfile() {
        return this.executors.getQueuedTaskCountForServerDefaultProfile();
    }

    public boolean isCellProcessingMultiThreaded() {
        List<OlapEngineMdxEvalProfile> profiles = this.configuration.getProfiles();
        for (OlapEngineMdxEvalProfile profile : profiles) {
            if (profile.getCellThreadCount() > 1) continue;
            return false;
        }
        return true;
    }

    public boolean isExtraProcessingActivated(OlapEngineMdxEvalProfile profile) {
        return profile.getExtraThreadCount() > 0;
    }

    public void acquireGlobalMdxRequestPermit(IOlapContext context) throws InterruptedException {
        OlapRequestTracker.onMdxRequestCountAcquirePermitStarted(context, this.globalActiveMdxCount, null);
        try {
            this.globalActiveMdxCount.acquire();
            OlapRequestTracker.onMdxRequestCountAcquirePermitDone(context, this.globalActiveMdxCount, null);
        }
        catch (InterruptedException ex) {
            OlapRequestTracker.onMdxRequestCountAcquirePermitInterrupted(context, this.globalActiveMdxCount, null);
            throw ex;
        }
    }

    public void releaseGlobalMdxRequestPermit(IOlapContext context) {
        OlapRequestTracker.onMdxRequestCountReleasePermitStarted(context, this.globalActiveMdxCount, null);
        try {
            this.globalActiveMdxCount.release();
        }
        finally {
            OlapRequestTracker.onMdxRequestCountReleasePermitDone(context, this.globalActiveMdxCount, null);
        }
    }

    public boolean acquireProfileMdxRequestPermit(IOlapContext context, OlapEngineMdxEvalProfile profile) throws InterruptedException {
        Semaphore permit = this.profileActiveMdxCounts.get(profile);
        if (permit != null) {
            OlapRequestTracker.onMdxRequestCountAcquirePermitStarted(context, permit, profile.getName());
            try {
                permit.acquire();
                OlapRequestTracker.onMdxRequestCountAcquirePermitDone(context, permit, profile.getName());
                return true;
            }
            catch (InterruptedException ex) {
                OlapRequestTracker.onMdxRequestCountAcquirePermitInterrupted(context, permit, profile.getName());
                throw ex;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseProfileMdxRequestPermit(IOlapContext context, OlapEngineMdxEvalProfile profile) {
        Semaphore permit = this.profileActiveMdxCounts.get(profile);
        if (permit == null) {
            throw new RuntimeException("internal error: missing MDX evaluation permit for profile (" + profile.getName() + ")");
        }
        OlapRequestTracker.onMdxRequestCountReleasePermitStarted(context, permit, profile.getName());
        try {
            permit.release();
        }
        finally {
            OlapRequestTracker.onMdxRequestCountReleasePermitDone(context, permit, profile.getName());
        }
    }

    public OlapMdxCellExecutorReference getOrCreateCellExecutor(OlapPrincipal principal, OlapEngineMdxEvalProfile profile) {
        OlapMdxCellExecutorReference executor = this.executors.getOrCreateCellExecutor(principal, profile);
        return executor;
    }

    public void releaseCellExecutor(OlapMdxCellExecutorReference executor) {
        this.executors.releaseCellExecutor(executor);
    }

    public OlapMdxExtraExecutorReference getOrCreateExtraExecutor(OlapPrincipal principal, OlapEngineMdxEvalProfile profile) {
        OlapMdxExtraExecutorReference executor = this.executors.getOrCreateExtraExecutor(principal, profile);
        return executor;
    }

    public void releaseExtraExecutor(OlapMdxExtraExecutorReference executor) {
        this.executors.releaseExtraExecutor(executor);
    }
}

