/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.common;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.result.OlapResDropAllBlankStatementDataSet;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapDropAllStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropAllStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropAllStatementExecutionContext> {
    public OlapDropAllStatementInstr(OlapInstrLocationRange range) {
        super(range);
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP *";
    }

    @Override
    public String toStringForDebugger() {
        return "DROP *";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropAllStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropAllStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OlapEntity doExecute(OlapDropAllStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropAllBlankStatementDataSet(schema.getName(), "?");
        }
        try {
            OlapInstrLocationRange errorLocation = context.getErrorLocation();
            IOlapSchemaPermission schemaPermissions = context.getSchemaPermissions();
            schema.removeAllDeclaredFunctions(errorLocation, schemaPermissions);
            schema.removeAllCalcMembers(errorLocation, schemaPermissions);
            schema.removeAllUserMeasures(errorLocation, schemaPermissions);
            schema.removeAllSetDeclarations(errorLocation, schemaPermissions);
            schema.removeAllCategoryHierarchies(errorLocation, schemaPermissions);
            schema.removeAllActions(errorLocation, schemaPermissions);
        }
        finally {
            this.onScriptStatementApplied(context, schema, true);
        }
        return new OlapResDropAllBlankStatementDataSet(schema.getName(), "?");
    }
}

