/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.command;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResExecCommandBlankStatementDataSet;
import crazydev.iccube.olap.eval.command.OlapExecCommandStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapExecCommandStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;

public class OlapMdxExecCommandStatementInstr
extends OlapExecCommandStatementInstr {
    private final MdxExpression expr;

    public OlapMdxExecCommandStatementInstr(OlapInstrLocationRange range, MdxExpression expr) {
        super(range);
        this.expr = expr;
    }

    @Override
    public String typeForError() {
        return super.typeForError() + " expr";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapEntity doExecute(OlapExecCommandStatementExecutionContext context) {
        OlapSchema schema = context.getSchema();
        OlapCube cube = schema.getFirstNullableCube();
        String cubeName = cube != null ? cube.getNameX() : null;
        OlapEngineMdxHelper helper = OlapEngineMdxHelper.create(context.getRequestContext());
        String mdx = this.expr.asMdx();
        try {
            OlapEntity ignored = helper.executeMdxValueExpression(schema, cubeName, mdx, "?");
            return new OlapResExecCommandBlankStatementDataSet(context.getSchemaName(), "?", "exec mdx-expr");
        }
        catch (CdMdxScannerException | MdxParserException unlikely) {
            throw new OlapEvaluationException((Throwable)unlikely, context, OlapErrorCode.IC3_RUN_MDX_ERROR, new Serializable[]{unlikely.getMessage()});
        }
    }

    @Override
    public String toStringForDebugger() {
        return super.toStringForDebugger() + " expr";
    }
}

