/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.command;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResExecCommandBlankStatementDataSet;
import crazydev.iccube.olap.eval.command.OlapExecCommandStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapExecCommandStatementExecutionContext;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.Serializable;

public class OlapCancelAllRequestsExecCommandStatementInstr
extends OlapExecCommandStatementInstr {
    private final boolean excludeLoad;

    public OlapCancelAllRequestsExecCommandStatementInstr(OlapInstrLocationRange range, boolean excludeLoad) {
        super(range);
        this.excludeLoad = excludeLoad;
    }

    @Override
    public String typeForError() {
        return super.typeForError() + " cancel_all_requests";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapEntity doExecute(OlapExecCommandStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        if (!perms.isMonitoringRequestsEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.monitoring / app.monitoring.requests"});
        }
        OlapEngineRequestContext reqContext = context.getRequestContext();
        IcCubeRequestStatusManager requestStatusManager = reqContext.getRequestStatusManager();
        String myUUID = context.getRequestUuid();
        int count = requestStatusManager.killAllRequests(myUUID, this.excludeLoad);
        return new OlapResExecCommandBlankStatementDataSet(context.getSchemaName(), "?", "cancel_all_requests");
    }

    @Override
    public String toStringForDebugger() {
        return super.toStringForDebugger() + " cancel_all_requests " + this.excludeLoad;
    }
}

