/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.catmember.OlapBaseCategoryMemberManager;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapSessionCategoryMemberManager
extends OlapBaseCategoryMemberManager {
    private OlapEngineSessionContext session;

    public OlapSessionCategoryMemberManager(OlapEngineSessionContext session) {
        this.session = session;
    }

    @Override
    public OlapHierarchyScope getScope() {
        return OlapHierarchyScope.SESSION;
    }

    @Override
    @Nullable
    public OlapEngineSessionContext getSessionContext() {
        return this.session;
    }

    @Override
    @Nullable
    public OlapEngineRequestContext getRequestContext() {
        return null;
    }

    public void onSessionDestroyed() {
        for (OlapBaseCategoryMemberManager.SchemaInformation schemaInformation : this.schemaInfos.values()) {
            schemaInformation.onSessionDestroyed();
        }
        this.schemaInfos.clear();
    }

    public void onSchemaLoadedOnError() {
        this.schemaInfos.clear();
    }

    public void onSchemaPartitionsUnloaded(OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onSchemaPartitionsUnloaded(unloadPartitionsInfo);
        }
    }

    public void onSchemaPartitionsLoaded(OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onSchemaPartitionsLoaded(loadPartitionsInfo);
        }
    }

    public void onSchemaPartitionsLoadError(OlapSchema schema) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onSchemaPartitionsLoadError();
        }
    }

    public void onSchemaIncrLoaded(OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onSchemaIncrLoaded(incrLoadInfo);
        }
    }

    public void onSchemaIncrLoadedOnError(OlapSchema schema) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onSchemaIncrLoadedOnError();
        }
    }

    public void onSchemaUnloaded(OlapSchema schema) {
        this.schemaInfos.remove(schema);
    }

    public void onScriptStatementApplied(OlapSchema schema, OlapScriptInformation information) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onScriptStatementApplied(information);
        }
    }

    public void onSecurityPermissionsRemoved(OlapSchema schema) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onSecurityPermissionsRemoved();
        }
    }

    public void onSecurityPermissionsSwitched(OlapSchema schema, @Nullable IOlapSchemaPermission permissions) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info != null) {
            info.onSecurityPermissionsSwitched(permissions);
        }
    }

    @Override
    protected OlapBaseCategoryMemberManager.SchemaInformation createSchemaInformation(OlapSchema schema) {
        return new SessionSchemaInformation(this, schema);
    }

    class SessionSchemaInformation
    extends OlapBaseCategoryMemberManager.SchemaInformation {
        SessionSchemaInformation(OlapSessionCategoryMemberManager this$0, OlapSchema schema) {
            Objects.requireNonNull(this$0);
            super(this$0, schema);
        }
    }
}

