/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.catmember.OlapCategoryHierarchyProperties;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.catmember.IOlapBaseCategoryMemberManager;
import crazydev.iccube.olap.eval.catmember.OlapCreateCategoryHierarchyHelper;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaCategoryMemberManager
implements IOlapBaseCategoryMemberManager {
    private final OlapSchema schema;

    public OlapSchemaCategoryMemberManager(OlapSchema schema) {
        this.schema = schema;
    }

    @Override
    public OlapHierarchyScope getScope() {
        return OlapHierarchyScope.SCHEMA;
    }

    @Override
    @Nullable
    public OlapEngineSessionContext getSessionContext() {
        return null;
    }

    @Override
    @Nullable
    public OlapEngineRequestContext getRequestContext() {
        return null;
    }

    public void onSchemaPartitionsUnloaded(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        this.deleteCategoryHierarchyBitmaps();
    }

    public void onSchemaPartitionsLoaded(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        this.deleteCategoryHierarchyBitmaps();
    }

    public void onSchemaPartitionsLoadError() {
        this.deleteCategoryHierarchyBitmaps();
    }

    public void onSchemaIncrLoaded(OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.deleteCategoryHierarchyBitmaps();
    }

    public void onSchemaIncrLoadedOnError() {
        this.deleteCategoryHierarchyBitmaps();
    }

    public void onSchemaUnloaded() {
        this.deleteCategoryHierarchyBitmaps();
    }

    public void onScriptStatementApplied(OlapScriptInformation information) {
        this.deleteCategoryHierarchyBitmaps();
    }

    public void onSecurityPermissionsRemoved() {
    }

    public void onSecurityPermissionsSwitched(@Nullable IOlapSchemaPermission permissions) {
    }

    private void deleteCategoryHierarchyBitmaps() {
        this.schema.resetAllCategoryMembers();
        this.schema.deleteAllCategoryHierarchyBitmaps();
    }

    public OlapHierarchy createCategoryMemberHierarchy(IOlapEvaluationExceptionContext errorContext, OlapNameContext nameContext, OlapDimension schemaDimension, String hierarchyName, OlapCategoryHierarchyProperties properties) {
        if (schemaDimension.lookupHierarchyByName(nameContext, hierarchyName) != null) {
            throw new OlapEvaluationException(errorContext, OlapErrorCode.CAT_HIERARCHY_DUPLICATED, new Serializable[]{this.getScope(), hierarchyName});
        }
        OlapHierarchy hierarchy = OlapCreateCategoryHierarchyHelper.createCategoryHierarchy(this.getScope(), -1, schemaDimension, hierarchyName, properties);
        schemaDimension.addHierarchy(hierarchy);
        return hierarchy;
    }
}

