/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapFactlessCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.result.OlapResDropCategoryMemberBlankStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapDropCategoryMemberStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapLookupCategoryMemberAnchorEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropCategoryMemberStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropCategoryMemberStatementExecutionContext> {
    private final boolean sessionScoped;
    private final List<OlapEntityIdentifier> ids;

    public OlapDropCategoryMemberStatementInstr(OlapInstrLocationRange range, boolean sessionScoped, List<OlapEntityIdentifier> ids) {
        super(range);
        this.sessionScoped = sessionScoped;
        this.ids = ids;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP CATEGORY MEMBER";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropCategoryMemberStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropCategoryMemberStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDropCategoryMemberStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapEntity executeForGlobalScope(OlapDropCategoryMemberStatementExecutionContext context) {
        this.assertAuthorizationForDropStatement(context);
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropCategoryMemberBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        boolean hasDeletedSomething = false;
        for (OlapEntityIdentifier id : this.ids) {
            if (!this.dropCategoryMember(context, schema, id)) continue;
            hasDeletedSomething = true;
        }
        if (hasDeletedSomething) {
            this.onScriptStatementApplied(context, schema, true);
        }
        return new OlapResDropCategoryMemberBlankStatementDataSet(schema.getName(), "?", this.getNames());
    }

    private OlapEntity executeForSessionScope(OlapDropCategoryMemberStatementExecutionContext context) {
        OlapSchema schema = context.getSchema();
        boolean hasDeletedSomething = false;
        for (OlapEntityIdentifier id : this.ids) {
            if (!this.dropCategoryMember(context, schema, id)) continue;
            hasDeletedSomething = true;
        }
        if (hasDeletedSomething) {
            this.onScriptStatementApplied(context, schema, false);
        }
        return new OlapResDropCategoryMemberBlankStatementDataSet(schema.getName(), "?", this.getNames());
    }

    private boolean dropCategoryMember(OlapDropCategoryMemberStatementExecutionContext context, OlapSchema schema, OlapEntityIdentifier id) {
        OlapHierarchy hierarchy;
        OlapFactlessCube cube = new OlapFactlessCube(this.getLocationRange(), "drop-category-member-", context.getSchema());
        OlapLookupCategoryMemberAnchorEvaluationContext evalContext = new OlapLookupCategoryMemberAnchorEvaluationContext(new OlapMdxStatementWithCubeSelectExecutionContext(context.getRequestContext(), context.getRequestProperties(), context.getAnnotations(), context.getInstrExecListener(), context.getSchema(), cube, true));
        OlapNonScalarEntity entity = evalContext.lookupEntityByMdxIdentifier(evalContext.getNameContext(), OlapMdxEntityLookupKinds.ALL_BUT_SET, id);
        if (entity.isMdxNull() || entity.isFilteredOut()) {
            return false;
        }
        if (entity instanceof OlapAbstractCategoryMember) {
            OlapAbstractCategoryMember member = (OlapAbstractCategoryMember)entity;
            OlapHierarchy hierarchy2 = member.getHierarchy();
            hierarchy2.deleteCategoryMember(member);
            return true;
        }
        if (entity instanceof OlapHierarchy && (hierarchy = (OlapHierarchy)entity).acceptCategoryMembers()) {
            hierarchy.deleteAllCategoryMembers();
            return true;
        }
        throw new OlapEvaluationException(context, OlapErrorCode.CAT_MEMBER_DROP_INVALID_TYPE, new Serializable[]{id.asString(), entity.getFriendlyTypeName()});
    }

    private String getNames() {
        StringBuilder sb = new StringBuilder();
        for (OlapEntityIdentifier id : this.ids) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id.asString());
        }
        return sb.toString();
    }

    @Override
    public String toStringForDebugger() {
        return "DROP CATEGORY MEMBER : " + this.ids.toString();
    }
}

