/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.calcmember;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.result.OlapResDropMeasureBlankStatementDataSet;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapDropMeasureStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropMeasureStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropMeasureStatementExecutionContext> {
    private final List<OlapEntityIdentifier> ids;

    public OlapDropMeasureStatementInstr(OlapInstrLocationRange range, List<OlapEntityIdentifier> ids) {
        super(range);
        this.ids = ids;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP MEASURE";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropMeasureStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropMeasureStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDropMeasureStatementExecutionContext context) {
        this.assertAuthorizationForDropStatement(context);
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropMeasureBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        StringBuilder sb = new StringBuilder();
        for (OlapEntityIdentifier id : this.ids) {
            OlapNameContext nameContext;
            OlapCube cube;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id.asString());
            String cubeName = null;
            if (id.getPartCount() > 1) {
                cubeName = id.getFirstPartAsName();
                if (OlapCaseInsensitiveName.equals("measures", cubeName)) {
                    cubeName = null;
                } else {
                    id = id.subIdentifier(1);
                }
            }
            if ((cube = context.lookupCubeEx(nameContext = context.getNameContext(), cubeName)) == null) {
                return (OlapEntity)OlapDropMeasureStatementInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEASURE_MISSING_CUBE, new Serializable[]{id.asString()});
            }
            this.dropCubeMeasure(context, cube, id);
        }
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResDropMeasureBlankStatementDataSet(schema.getName(), "?", sb.toString());
    }

    private void dropCubeMeasure(OlapDropMeasureStatementExecutionContext context, OlapCube cube, OlapEntityIdentifier id) {
        OlapNameContext nameContext = context.getNameContext();
        OlapCubeCalculatedMemberManager calcMemberManager = cube.getCalcMemberManager();
        OlapUserMeasureMember member = calcMemberManager.lookupUserMeasure(nameContext, id);
        IOlapSchemaPermission perms = context.getSchemaPermissions();
        IOlapCubePermission cubePerms = perms.getCubePermissions(cube);
        calcMemberManager.deleteUserMeasure(context.getErrorLocation(), cubePerms, member);
    }

    @Override
    public String toStringForDebugger() {
        return "DROP MEASURE : " + this.ids.toString();
    }
}

