/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.calcmember;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.result.OlapResDropCalcMemberBlankStatementDataSet;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapDropCalcMemberStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropCalcMemberStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropCalcMemberStatementExecutionContext> {
    private final boolean sessionScoped;
    private final List<OlapEntityIdentifier> ids;

    public OlapDropCalcMemberStatementInstr(OlapInstrLocationRange range, boolean sessionScoped, List<OlapEntityIdentifier> ids) {
        super(range);
        this.sessionScoped = sessionScoped;
        this.ids = ids;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP CALCULATED MEMBER";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropCalcMemberStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropCalcMemberStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDropCalcMemberStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapEntity executeForGlobalScope(OlapDropCalcMemberStatementExecutionContext context) {
        this.assertAuthorizationForDropStatement(context);
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropCalcMemberBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        StringBuilder sb = new StringBuilder();
        for (OlapEntityIdentifier id : this.ids) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id.asString());
            OlapEntityIdentifier cubePart = id.subIdentifier(0, 1);
            OlapNameContext nameContext = context.getNameContext();
            OlapCube cube = context.lookupCube(nameContext, cubePart.getFirstPartAsName());
            if (cube != null) {
                if (id.getPartCount() == 1) {
                    return (OlapEntity)OlapDropCalcMemberStatementInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEASURE_MISSING_NAME, new Serializable[]{id.asString()});
                }
                this.dropCubeCalcMember(context, cube, id.subIdentifier(1));
                continue;
            }
            if (OlapCaseInsensitiveName.equals(id.getFirstPartAsName(), "Measures") || id.getPartCount() == 1) {
                if (schema.getCubeCount() == 1) {
                    this.dropCubeCalcMember(context, schema.getFirstCube(), id);
                    continue;
                }
                return (OlapEntity)OlapDropCalcMemberStatementInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEASURE_MISSING_CUBE, new Serializable[]{id.asString()});
            }
            this.dropSchemaCalcMember(context, schema, id);
        }
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResDropCalcMemberBlankStatementDataSet(schema.getName(), "?", sb.toString());
    }

    private void dropCubeCalcMember(OlapDropCalcMemberStatementExecutionContext context, OlapCube cube, OlapEntityIdentifier id) {
        OlapNameContext nameContext = context.getNameContext();
        OlapCubeCalculatedMemberManager calcMemberManager = cube.getCalcMemberManager();
        OlapMember member = calcMemberManager.lookupCalculatedMember(nameContext, id);
        IOlapSchemaPermission perms = context.getSchemaPermissions();
        IOlapCubePermission cubePerms = perms.getCubePermissions(cube);
        calcMemberManager.delete(context.getErrorLocation(), cubePerms, member);
    }

    private void dropSchemaCalcMember(OlapDropCalcMemberStatementExecutionContext context, OlapSchema schema, OlapEntityIdentifier id) {
        OlapNameContext nameContext = context.getNameContext();
        OlapSchemaCalculatedMemberManager calcMemberManager = schema.getCalcMemberManager();
        OlapMember member = calcMemberManager.lookupCalculatedMember(nameContext, id);
        calcMemberManager.delete(context.getErrorLocation(), context.getSchemaPermissions(), member);
    }

    private OlapEntity executeForSessionScope(OlapDropCalcMemberStatementExecutionContext context) {
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropCalcMemberBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        StringBuilder sb = new StringBuilder();
        for (OlapEntityIdentifier id : this.ids) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id.asString());
            OlapEntityIdentifier cubePart = id.subIdentifier(0, 1);
            OlapNameContext nameContext = context.getNameContext();
            OlapCube cube = context.lookupCube(nameContext, cubePart.getFirstPartAsName());
            if (cube != null) {
                if (id.getPartCount() == 1) {
                    return (OlapEntity)OlapDropCalcMemberStatementInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEASURE_MISSING_NAME, new Serializable[]{id.asString()});
                }
                this.dropSessionCubeCalcMember(context, cube, id.subIdentifier(1));
                continue;
            }
            if (OlapCaseInsensitiveName.equals(id.getFirstPartAsName(), "Measures") || id.getPartCount() == 1) {
                if (schema.getCubeCount() == 1) {
                    this.dropSessionCubeCalcMember(context, schema.getFirstCube(), id);
                    continue;
                }
                return (OlapEntity)OlapDropCalcMemberStatementInstr.onInstrExecutionError(context, OlapErrorCode.CALC_MEASURE_MISSING_CUBE, new Serializable[]{id.asString()});
            }
            this.dropSessionSchemaCalcMember(context, schema, id);
        }
        this.onScriptStatementApplied(context, schema, false);
        return new OlapResDropCalcMemberBlankStatementDataSet(schema.getName(), "?", sb.toString());
    }

    private void dropSessionCubeCalcMember(OlapDropCalcMemberStatementExecutionContext context, OlapCube cube, OlapEntityIdentifier id) {
        context.removeSessionCalcMember(context.getNameContext(), id, cube);
    }

    private void dropSessionSchemaCalcMember(OlapDropCalcMemberStatementExecutionContext context, OlapSchema schema, OlapEntityIdentifier id) {
        context.removeSessionCalcMember(context.getNameContext(), id, null);
    }

    @Override
    public String toStringForDebugger() {
        return "DROP CALCULATED MEMBER : " + this.ids.toString();
    }
}

