/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.store;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReference;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import java.text.SimpleDateFormat;
import org.jetbrains.annotations.Nullable;

public class OlapResultDefaultStoreReference
extends OlapResultStoreReference {
    private static long SHALLOW_SIZE_OF = -1L;
    private final long sizeOf;
    private int hit;
    private long lastUsed;

    public OlapResultDefaultStoreReference(@Nullable OlapResultStoreInformation info, OlapResultStoreReferenceKey resultKey, int decompressedSize, int size, int[] chunks) {
        this(info, resultKey, decompressedSize, size, chunks, -1, -1L);
    }

    public OlapResultDefaultStoreReference(@Nullable OlapResultStoreInformation info, OlapResultStoreReferenceKey resultKey, int decompressedSize, int size, int[] chunks, int hit, long lastUsed) {
        super(info, resultKey, decompressedSize, size, chunks);
        long sizeOf;
        this.hit = hit;
        this.lastUsed = lastUsed;
        long l = sizeOf = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        if (resultKey != null) {
            sizeOf += resultKey.sizeOf();
        }
        sizeOf += CdRamUsageEstimator.sizeOf((int[])chunks);
        if (info != null) {
            sizeOf += info.sizeOf();
        }
        this.sizeOf = sizeOf;
    }

    @Override
    public long sizeOf() {
        return this.sizeOf;
    }

    public int getHit() {
        return this.hit;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void recordAccess() {
        this.lastUsed = System.currentTimeMillis();
        ++this.hit;
    }

    @Override
    public void recordRemoval() {
        super.recordRemoval();
        this.hit = -1;
        this.lastUsed = -1L;
    }

    public String toString() {
        return this.lastUsed == -1L ? "n/a" : new SimpleDateFormat("hh:mm:ss S").format(this.lastUsed);
    }
}

