/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.store;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.lang.MathX;
import crazydev.iccube.olap.eval.cache.result.store.IOlapResultStoreEvictionPolicy;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultDefaultStoreReference;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReference;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class OlapResultDefaultStoreEvictionPolicy
implements IOlapResultStoreEvictionPolicy {
    private final SortedSet<OlapResultDefaultStoreReference> references = new TreeSet<OlapResultDefaultStoreReference>(new MyComparator());

    @Override
    public boolean isEmpty() {
        return this.references.isEmpty();
    }

    @Override
    public OlapResultStoreReference getReferenceToDelete() {
        return !this.references.isEmpty() ? (OlapResultStoreReference)this.references.first() : null;
    }

    @Override
    public OlapResultStoreReference createAndAddReference(@Nullable OlapResultStoreInformation info, OlapResultStoreReferenceKey resultKey, int decompressedSize, int size, int[] chunks) {
        return this.addReference(new OlapResultDefaultStoreReference(info, resultKey, decompressedSize, size, chunks));
    }

    public OlapResultStoreReference createAndAddReference(OlapResultStoreReferenceKey resultKey, int decompressedSize, int size, int[] chunks, int hit, long lastUsed) {
        return this.addReference(new OlapResultDefaultStoreReference(null, resultKey, decompressedSize, size, chunks, hit, lastUsed));
    }

    private OlapResultStoreReference addReference(OlapResultDefaultStoreReference storeReference) {
        storeReference.recordAccess();
        if (!this.references.add(storeReference)) {
            throw new CdProgrammingException("internal error: unexpected duplicated store reference");
        }
        return storeReference;
    }

    @Override
    public void recordReferenceAccess(OlapResultStoreReference reference) {
        OlapResultDefaultStoreReference storeReference = (OlapResultDefaultStoreReference)reference;
        if (!this.references.remove(storeReference)) {
            throw new CdProgrammingException("internal error: missing store reference");
        }
        storeReference.recordAccess();
        if (!this.references.add(storeReference)) {
            throw new CdProgrammingException("internal error: unexpected duplicated store reference");
        }
    }

    @Override
    public void recordReferenceRemoval(OlapResultStoreReference reference) {
        OlapResultDefaultStoreReference storeReference = (OlapResultDefaultStoreReference)reference;
        if (!this.references.remove(storeReference)) {
            throw new CdProgrammingException("internal error: unexpected store reference usage");
        }
    }

    static class MyComparator
    implements Comparator<OlapResultDefaultStoreReference> {
        MyComparator() {
        }

        @Override
        public int compare(OlapResultDefaultStoreReference o1, OlapResultDefaultStoreReference o2) {
            if (o1 == o2) {
                return 0;
            }
            int hitCmp = MathX.compare((int)o1.getHit(), (int)o2.getHit());
            if (hitCmp != 0) {
                return hitCmp;
            }
            long lastUsedDiff = o1.getLastUsed() - o2.getLastUsed();
            if (lastUsedDiff != 0L) {
                return lastUsedDiff < 0L ? -1 : 1;
            }
            int sizeCmp = MathX.compare((int)o1.getSize(), (int)o2.getSize());
            if (sizeCmp != 0) {
                return sizeCmp;
            }
            int[] chunks1 = o1.getChunks();
            int[] chunks2 = o2.getChunks();
            if (chunks1 == null || chunks2 == null) {
                throw new CdProgrammingException("internal error: inconsistent store reference");
            }
            int chunkCountCmp = MathX.compare((int)chunks1.length, (int)chunks2.length);
            if (chunkCountCmp != 0) {
                return chunkCountCmp;
            }
            for (int ii = 0; ii < chunks1.length; ++ii) {
                int chunkCmp = MathX.compare((int)chunks1[ii], (int)chunks2[ii]);
                if (chunkCmp == 0) continue;
                return chunkCmp;
            }
            throw new CdProgrammingException("internal error: inconsistent store reference");
        }
    }
}

