/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.lz4;

import crazydev.iccube.olap.eval.cache.result.lz4.OlapLZ4CompressedOutputStream;
import crazydev.iccube.olap.eval.cache.result.lz4.OlapLZ4MemoryDecompressedOutputStream;
import crazydev.iccube.olap.eval.cache.result.lz4.OlapLZ4Result;
import crazydev.iccube.olap.eval.cache.result.lz4.OlapLZ4SizeCalculatorOutputStream;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.jetbrains.annotations.Nullable;

public abstract class OlapLZ4Helper {
    @Nullable
    public static OlapLZ4Result compress(boolean compression, int maxResultSize, OlapResultStoreSerializer resultSerializer) throws IOException {
        int decompressedResultSize;
        OlapLZ4CompressedOutputStream compressed = new OlapLZ4CompressedOutputStream(maxResultSize);
        if (compression) {
            int blockSize = 65536;
            LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
            LZ4BlockOutputStream lz4out = new LZ4BlockOutputStream((OutputStream)compressed, 65536, compressor);
            OlapLZ4SizeCalculatorOutputStream sizeOut = new OlapLZ4SizeCalculatorOutputStream((OutputStream)lz4out);
            resultSerializer.write(sizeOut);
            sizeOut.flush();
            sizeOut.close();
            decompressedResultSize = sizeOut.getSize();
        } else {
            resultSerializer.write(compressed);
            compressed.flush();
            compressed.close();
            decompressedResultSize = compressed.size();
        }
        if (compressed.isMaxSizeReached()) {
            return null;
        }
        byte[] compressedResult = compressed.buffer();
        int compressedResultLen = compressed.size();
        return new OlapLZ4Result(decompressedResultSize, compressedResultLen, compressedResult);
    }

    public static byte[] decompress(boolean compression, int decompressedLength, byte[] compressedResult) throws IOException {
        if (!compression) {
            return compressedResult;
        }
        OlapLZ4MemoryDecompressedOutputStream out = new OlapLZ4MemoryDecompressedOutputStream(decompressedLength);
        OlapLZ4Helper.decompress(out, true, decompressedLength, compressedResult);
        out.close();
        byte[] decompressed = out.getBuffer();
        return decompressed;
    }

    public static void decompress(OutputStream out, boolean compression, int decompressedLength, byte[] compressedResult) throws IOException {
        int count;
        ByteArrayInputStream in;
        ByteArrayInputStream compressed = new ByteArrayInputStream(compressedResult);
        if (compression) {
            LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
            LZ4BlockInputStream lz4in = new LZ4BlockInputStream((InputStream)compressed, decompressor);
            in = lz4in;
        } else {
            in = compressed;
        }
        byte[] buffer = new byte[65536];
        while (-1 != (count = in.read(buffer))) {
            out.write(buffer, 0, count);
        }
        ((InputStream)in).close();
        out.flush();
    }
}

