/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.cache;

import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.Date;
import java.util.Locale;

public class OlapResultCacheKey {
    private final String roleName;
    private final Locale locale;
    private final OlapSchema schema;
    private final IOlapSchemaPermission schemaPermission;

    public OlapResultCacheKey(String roleName, Locale locale, OlapSchema schema, IOlapSchemaPermission schemaPermission) {
        this.roleName = roleName;
        this.locale = locale;
        this.schema = schema;
        this.schemaPermission = schemaPermission;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getSchemaName() {
        return this.schema.getName();
    }

    public String getSchemaId() {
        return this.schema.getUuid();
    }

    public Date getSchemaRefreshTime() {
        return this.schema.getInformation().getRefreshTimeStart();
    }

    public OlapSchema getSchema() {
        return this.schema;
    }

    public IOlapSchemaPermission getSchemaPermission() {
        return this.schemaPermission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapResultCacheKey that = (OlapResultCacheKey)o;
        if (this.roleName != null ? !this.roleName.equals(that.roleName) : that.roleName != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        return this.schemaPermission != null ? this.schemaPermission.equals(that.schemaPermission) : that.schemaPermission == null;
    }

    public int hashCode() {
        int result = this.roleName != null ? this.roleName.hashCode() : 0;
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        result = 31 * result + (this.schemaPermission != null ? this.schemaPermission.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.schema.getName() + " [" + System.identityHashCode(this.schema) + "] [" + System.identityHashCode(this.schemaPermission) + "]";
    }
}

