/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.cache;

import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.cache.result.cache.IOlapResultCachePolicy;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class OlapResultCacheBufferedPolicy
implements IOlapResultCachePolicy {
    public static final String PROP_BUFFERED_REQUEST_COUNT_ = "rcp.bufferedRequestCount";
    public static final String PROP_BUFFERED_REQUEST_COUNT = "bufferedRequestCount";
    public static final int DEFAULT_BUFFERED_REQUEST_COUNT = 1024;
    private BufferedRequests bufferedRequests;

    @Override
    public void configure(IOlapServiceConfiguration properties) throws OlapConfigurationException {
        int bufferedRequestCount = properties.getConfigurationIntProperty(PROP_BUFFERED_REQUEST_COUNT, 1024);
        this.bufferedRequests = new BufferedRequests(bufferedRequestCount);
    }

    @Override
    public boolean canCache(OlapEngineRequestContext context, OlapResultCacheKey cacheKey, OlapResultStoreReferenceKey resultKey) {
        boolean forMdxCacheRebuild = context.isForMdxCacheRebuild();
        BufferedRequestKey bufferedRequestKey = new BufferedRequestKey(cacheKey, resultKey);
        if (!forMdxCacheRebuild && !this.bufferedRequests.containsKey(bufferedRequestKey)) {
            this.bufferedRequests.put(bufferedRequestKey, true);
            return false;
        }
        this.bufferedRequests.remove(bufferedRequestKey);
        return true;
    }

    @Override
    public void onSchemaIncrLoaded(OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
    }

    @Override
    public void onSchemaIncrLoadedOnError(OlapSchema schema) {
        this.clearBufferedRequests(schema);
    }

    @Override
    public void onSchemaUnloaded(OlapSchema schema) {
        this.clearBufferedRequests(schema);
    }

    @Override
    public void onSchemaPartitionsUnloaded(OlapSchema schema) {
    }

    @Override
    public void onSchemaPartitionsLoaded(OlapSchema schema) {
    }

    @Override
    public void onSchemaPartitionsLoadError(OlapSchema schema) {
        this.clearBufferedRequests(schema);
    }

    private void clearBufferedRequests(OlapSchema schema) {
        ArrayList<BufferedRequestKey> toRemove = null;
        for (BufferedRequestKey key : this.bufferedRequests.keySet()) {
            if (!key.cacheKey.getSchema().equals(schema)) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<BufferedRequestKey>();
            }
            toRemove.add(key);
        }
        if (toRemove != null) {
            for (BufferedRequestKey key : toRemove) {
                this.bufferedRequests.remove(key);
            }
        }
    }

    @Override
    public void reset() {
        this.bufferedRequests.clear();
    }

    static class BufferedRequests
    extends LinkedHashMap<BufferedRequestKey, Boolean> {
        private static final long serialVersionUID = 3262175583911154068L;
        private final int maxSize;

        public BufferedRequests(int maxSize) {
            super(16, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<BufferedRequestKey, Boolean> eldest) {
            return this.size() > this.maxSize;
        }
    }

    static class BufferedRequestKey {
        private final OlapResultCacheKey cacheKey;
        private final int resultKeyHash;
        private final int resultKeyMdxSize;

        public BufferedRequestKey(OlapResultCacheKey cacheKey, OlapResultStoreReferenceKey resultKey) {
            this.cacheKey = cacheKey;
            this.resultKeyHash = resultKey.hashCode();
            this.resultKeyMdxSize = resultKey.getMdxSize();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferedRequestKey that = (BufferedRequestKey)o;
            if (this.resultKeyHash != that.resultKeyHash) {
                return false;
            }
            if (this.resultKeyMdxSize != that.resultKeyMdxSize) {
                return false;
            }
            return !(this.cacheKey != null ? !this.cacheKey.equals(that.cacheKey) : that.cacheKey != null);
        }

        public int hashCode() {
            int result = this.cacheKey != null ? this.cacheKey.hashCode() : 0;
            result = 31 * result + this.resultKeyHash;
            result = 31 * result + this.resultKeyMdxSize;
            return result;
        }
    }
}

