/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.cache;

import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapMdxAuditManager;
import crazydev.iccube.olap.eval.cache.result.cache.OlapGlobalResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import crazydev.iccube.pub.principal.OlapPrincipal;
import org.jetbrains.annotations.Nullable;

public class OlapResultCache {
    private final OlapResultCacheKey cacheKey;
    private final OlapGlobalResultCache globalResultCache;

    public OlapResultCache(OlapResultCacheKey cacheKey, OlapGlobalResultCache globalResultCache) {
        this.cacheKey = cacheKey;
        this.globalResultCache = globalResultCache;
    }

    public OlapResultCacheKey getCacheKey() {
        return this.cacheKey;
    }

    public void clear(OlapEngineRequestContext context) {
        this.globalResultCache.clear(context, this.cacheKey);
    }

    public boolean addResult(OlapEngineRequestContext context, OlapResultStoreReferenceKey resultKey, OlapResultStoreSerializer resultSerializer) {
        return this.globalResultCache.addResult(context, this.cacheKey, resultKey, resultSerializer);
    }

    @Nullable
    public OlapResultStoreDeSerializer getResult(OlapEngineRequestContext context, OlapResultStoreReferenceKey resultKey) {
        return this.getResult(context, resultKey, null);
    }

    @Nullable
    public OlapResultStoreDeSerializer getResult(OlapEngineRequestContext context, OlapResultStoreReferenceKey resultKey, @Nullable String reportPath) {
        long startMS = System.currentTimeMillis();
        OlapResultStoreDeSerializer result = this.globalResultCache.getResult(context, this.cacheKey, resultKey);
        if (result != null) {
            this.auditMdx(context, reportPath, resultKey, startMS);
        }
        return result;
    }

    private void auditMdx(OlapEngineRequestContext context, @Nullable String reportPath, OlapResultStoreReferenceKey resultKey, long startMS) {
        OlapMdxAuditManager audit = context.getApplicationContext().getMdxAuditManager();
        if (audit != null && audit.hasListeners()) {
            OlapPrincipal principal = context.getUser();
            String tenant = principal.getTenantName();
            String user = principal.getName();
            long elapsedMS = System.currentTimeMillis() - startMS;
            String statement = resultKey.getMdx();
            audit.onMdxExecuted(true, reportPath, tenant, user, this.cacheKey.getSchemaName(), null, statement, startMS, elapsedMS);
        }
    }
}

