/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.cache.result.cache;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.cache.result.cache.IOlapResultCachePolicy;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheStats;
import crazydev.iccube.olap.eval.cache.result.store.IOlapResultStoreListener;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultMemoryStore;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultMmapStore;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStore;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReference;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.pub.common.IOlapProtocol;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapGlobalResultCache {
    private final Set<OlapSchema> loadedSchema = new HashSet<OlapSchema>();
    private final OlapResultStore store;
    private final Map<OlapResultCacheKey, Map<OlapResultStoreReferenceKey, OlapResultStoreReference>> allStoreReferences;
    private final IOlapResultCachePolicy cachingPolicy;
    private final boolean cachingGVI;
    private final boolean cachingXMLA;
    private final boolean cachingREST;
    private final boolean cachingAlerts;
    private boolean invalidated;
    private int accessTotal;
    private int hitTotal;
    private int missTotal;
    private int addTotal;

    public OlapGlobalResultCache(CdVFileSystem vfs, @Nullable File tmpDirectory, boolean compressionEnabled, int resultStoreSize, IOlapResultCachePolicy cachingPolicy, boolean cachingGVI, boolean cachingXMLA, boolean cachingREST, boolean cachingAlerts) {
        IOlapResultStoreListener listener = new IOlapResultStoreListener(this){
            final /* synthetic */ OlapGlobalResultCache this$0;
            {
                OlapGlobalResultCache olapGlobalResultCache = this$0;
                Objects.requireNonNull(olapGlobalResultCache);
                this.this$0 = olapGlobalResultCache;
            }

            @Override
            public void onReferenceRemoved(OlapResultStoreReference reference) {
                this.this$0.onStoreReferenceRemove(reference);
            }
        };
        this.store = tmpDirectory == null ? new OlapResultMemoryStore(listener, vfs, compressionEnabled, resultStoreSize) : new OlapResultMmapStore(listener, vfs, tmpDirectory, compressionEnabled, resultStoreSize);
        this.allStoreReferences = new HashMap<OlapResultCacheKey, Map<OlapResultStoreReferenceKey, OlapResultStoreReference>>();
        this.cachingPolicy = cachingPolicy;
        this.cachingGVI = cachingGVI;
        this.cachingXMLA = cachingXMLA;
        this.cachingREST = cachingREST;
        this.cachingAlerts = cachingAlerts;
    }

    public boolean isEnabled(IOlapProtocol protocol) {
        switch (protocol) {
            case GVI: {
                return this.cachingGVI;
            }
            case XMLA: {
                return this.cachingXMLA;
            }
            case REST_API: {
                return this.cachingREST;
            }
        }
        return false;
    }

    public boolean isEnabledForAlerts() {
        return this.cachingAlerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapResultCacheStats getStats() {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            if (!this.invalidated) {
                HashSet<OlapSchema> schemas = new HashSet<OlapSchema>();
                for (OlapResultCacheKey cacheKey : this.allStoreReferences.keySet()) {
                    schemas.add(cacheKey.getSchema());
                }
                int schemaCount = schemas.size();
                int referenceCount = this.allStoreReferences.size();
                int keyCollisions = 0;
                for (Map<OlapResultStoreReferenceKey, OlapResultStoreReference> cacheReferences : this.allStoreReferences.values()) {
                    HashSet<Integer> hashes = new HashSet<Integer>();
                    for (OlapResultStoreReferenceKey keys : cacheReferences.keySet()) {
                        int hash = keys.hashCode();
                        if (!hashes.contains(hash)) {
                            hashes.add(hash);
                            continue;
                        }
                        ++keyCollisions;
                    }
                }
                return new OlapResultCacheStats(false, schemaCount, referenceCount, this.store.isMemory() ? "MEMORY" : "FILE", this.store.isMemory(), this.store.isMmap(), this.cachingGVI, this.cachingXMLA, this.cachingREST, this.cachingAlerts, this.cachingPolicy.getClass().getName(), this.store.indexSizeOf(), this.store.sizeOf(), this.store.sizeOfFiles(), this.store.getFillPercent(), this.store.getCompressionRatio(), this.store.getItemCount(), this.store.getEvictedItemCount(), this.addTotal, this.accessTotal, this.hitTotal, this.missTotal, keyCollisions);
            }
            return new OlapResultCacheStats(true, -1, -1, "n/a", false, false, false, false, false, false, "n/a", -1L, -1L, -1L, -1.0, -1.0, -1, -1, -1, -1, -1, -1, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(OlapEngineRequestContext context, OlapResultCacheKey key) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            if (this.invalidated) {
                return;
            }
            Map<OlapResultStoreReferenceKey, OlapResultStoreReference> storeReferences = this.allStoreReferences.get(key);
            if (storeReferences != null) {
                for (Map.Entry<OlapResultStoreReferenceKey, OlapResultStoreReference> entry : storeReferences.entrySet()) {
                    OlapResultStoreReference storeReference = entry.getValue();
                    if (!this.store.deleteResult(storeReference, false)) continue;
                    OlapResultStoreReferenceKey storeKey = entry.getKey();
                    context.onMdxResultCacheRemoved(key, storeKey);
                }
                this.allStoreReferences.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaLoaded(OlapSchema schema) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            if (!this.loadedSchema.add(schema)) {
                throw new RuntimeException("internal error: (load) loaded schema inconsistency");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaIncrLoaded(OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            this.cachingPolicy.onSchemaIncrLoaded(schema, incrLoadInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaIncrLoadedOnError(OlapSchema schema) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            this.cachingPolicy.onSchemaIncrLoadedOnError(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaUnloaded(OlapSchema schema) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            if (!this.loadedSchema.remove(schema)) {
                throw new CdProgrammingException("internal error: (unload) loaded schema inconsistency");
            }
            this.cachingPolicy.onSchemaUnloaded(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaPartitionsUnloaded(OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            this.cachingPolicy.onSchemaPartitionsUnloaded(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaPartitionsLoaded(OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            this.cachingPolicy.onSchemaPartitionsLoaded(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaPartitionsLoadError(OlapSchema schema) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            this.cachingPolicy.onSchemaPartitionsLoadError(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeyActive(OlapResultCacheKey key) {
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            OlapSchema schema = key.getSchema();
            IOlapSchemaPermission perms = key.getSchemaPermission();
            return this.loadedSchema.contains(schema) && schema.containsSecurityPermissions(perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addResult(OlapEngineRequestContext context, OlapResultCacheKey cacheKey, OlapResultStoreReferenceKey resultKey, OlapResultStoreSerializer resultSerializer) {
        OlapSchema schema = cacheKey.getSchema();
        if (!context.canUseResultCache(schema)) {
            return false;
        }
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            if (this.invalidated) {
                return false;
            }
            try {
                return this.unsafeAddResult(context, cacheKey, resultKey, resultSerializer);
            }
            catch (RuntimeException ex) {
                OlapLoggers.MDX_EVALUATION_RESULT_CACHE.error((Object)"[result-cache] invalidated due to an unexpected error (add-result)", (Throwable)ex);
                this.invalidate();
                return false;
            }
        }
    }

    private boolean unsafeAddResult(OlapEngineRequestContext context, OlapResultCacheKey cacheKey, OlapResultStoreReferenceKey resultKey, OlapResultStoreSerializer resultSerializer) {
        OlapResultStoreReference existingStoreReference;
        if (!this.isKeyActive(cacheKey)) {
            return false;
        }
        Map<OlapResultStoreReferenceKey, OlapResultStoreReference> references = this.allStoreReferences.get(cacheKey);
        if (references != null && (existingStoreReference = references.get(resultKey)) != null) {
            this.store.recordReferenceAccess(existingStoreReference);
            return false;
        }
        if (!this.cachingPolicy.canCache(context, cacheKey, resultKey)) {
            return false;
        }
        OlapResultStoreReference storeReference = this.store.addResult(resultKey, resultSerializer);
        if (storeReference == null) {
            return false;
        }
        if (references == null) {
            references = new HashMap<OlapResultStoreReferenceKey, OlapResultStoreReference>();
            this.allStoreReferences.put(cacheKey, references);
        }
        references.put(resultKey, storeReference);
        ++this.addTotal;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapResultStoreDeSerializer getResult(OlapEngineRequestContext context, OlapResultCacheKey cacheKey, OlapResultStoreReferenceKey resultKey) {
        OlapSchema schema = cacheKey.getSchema();
        if (!context.canUseResultCache(schema)) {
            return null;
        }
        OlapResultStore olapResultStore = this.store;
        synchronized (olapResultStore) {
            if (this.invalidated) {
                return null;
            }
            try {
                return this.unsafeGetResult(cacheKey, resultKey);
            }
            catch (RuntimeException ex) {
                OlapLoggers.MDX_EVALUATION_RESULT_CACHE.error((Object)"[result-cache] invalidated due to an unexpected error (get-result)", (Throwable)ex);
                this.invalidate();
                return null;
            }
        }
    }

    @Nullable
    private OlapResultStoreDeSerializer unsafeGetResult(OlapResultCacheKey cacheKey, OlapResultStoreReferenceKey resultKey) {
        ++this.accessTotal;
        Map<OlapResultStoreReferenceKey, OlapResultStoreReference> references = this.allStoreReferences.get(cacheKey);
        if (references == null) {
            ++this.missTotal;
            return null;
        }
        OlapResultStoreReference storeReference = references.get(resultKey);
        if (storeReference == null) {
            ++this.missTotal;
            return null;
        }
        OlapResultStoreDeSerializer result = this.store.getResult(storeReference);
        if (result == null) {
            ++this.missTotal;
            references.remove(resultKey);
        } else {
            ++this.hitTotal;
        }
        return result;
    }

    private void onStoreReferenceRemove(OlapResultStoreReference reference) {
        OlapResultStoreReferenceKey mdx = reference.getResultKey();
        for (Map<OlapResultStoreReferenceKey, OlapResultStoreReference> references : this.allStoreReferences.values()) {
            references.remove(mdx);
        }
    }

    private void invalidate() {
        this.invalidated = true;
        this.allStoreReferences.clear();
        this.cachingPolicy.reset();
    }
}

