/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.action;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughAction {
    private final String name;
    @Nullable
    private final Long maxRows;
    private final List<OlapDrillthroughReturn> returns;
    @Nullable
    private final String targetQN;

    public OlapDrillthroughAction(String name, @Nullable Long maxRows, List<OlapDrillthroughReturn> returns, @Nullable String targetQN) {
        this.name = name;
        this.maxRows = maxRows;
        this.returns = returns;
        this.targetQN = targetQN;
    }

    public String getName() {
        return this.name;
    }

    public String getStatement(String cubeName, String coordinate) {
        String cube = "[" + CdMdxUtils.escape((String)cubeName) + "]";
        String rows = this.maxRows != null ? "MAXROWS " + this.maxRows : "";
        String returns = this.returns.stream().map(OlapDrillthroughReturn::getStatement).collect(Collectors.joining(","));
        return String.format("DRILLTHROUGH %s SELECT %s on 0 FROM %s RETURN %s", rows, coordinate, cube, returns);
    }

    public boolean isBoundToMeasureGroup(@Nullable String measureGroupQN) {
        if (this.targetQN == null) {
            return true;
        }
        if (measureGroupQN == null) {
            return false;
        }
        return OlapCaseInsensitiveName.equals(measureGroupQN, this.targetQN);
    }
}

