/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.action;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.action.OlapDrillthroughAction;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapActionManager {
    private final Map<String, OlapDrillthroughAction> actions = new CdCaseInsensitiveHashMap();
    private final OlapSchema schema;

    public OlapActionManager(OlapSchema schema) {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        Map<String, OlapDrillthroughAction> map = this.actions;
        synchronized (map) {
            return this.actions.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDrillthroughActionCount() {
        Map<String, OlapDrillthroughAction> map = this.actions;
        synchronized (map) {
            return this.actions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapDrillthroughAction> getDrillthroughActions(String cubeName, OlapTuple tuple) {
        String coordinateMeasureGroupQN = this.getCoordinateMeasureGroupQN(cubeName, tuple);
        Map<String, OlapDrillthroughAction> map = this.actions;
        synchronized (map) {
            ArrayList<OlapDrillthroughAction> actionsDT = new ArrayList<OlapDrillthroughAction>();
            for (OlapDrillthroughAction action : this.actions.values()) {
                if (!action.isBoundToMeasureGroup(coordinateMeasureGroupQN)) continue;
                actionsDT.add(action);
            }
            return actionsDT;
        }
    }

    @Nullable
    private String getCoordinateMeasureGroupQN(String cubeName, OlapTuple tuple) {
        OlapCalculatedMember coordinateEvalMemberCM;
        OlapMember coordinateEvalMember = tuple.getMeasureMember();
        OlapCalculatedMember olapCalculatedMember = coordinateEvalMemberCM = coordinateEvalMember instanceof OlapCalculatedMember ? (OlapCalculatedMember)coordinateEvalMember : null;
        if (tuple.getMemberCount() > 1) {
            for (int mm = 0; mm < tuple.getMemberCount(); ++mm) {
                OlapMember member = tuple.getMember(mm);
                if (!(member instanceof OlapCalculatedMember)) continue;
                OlapCalculatedMember memberC = (OlapCalculatedMember)member;
                coordinateEvalMemberCM = coordinateEvalMemberCM == null ? memberC : OlapCalculatedMember.highestPriorityMember(null, coordinateEvalMemberCM, memberC);
            }
        }
        if (coordinateEvalMemberCM != null) {
            String mg = coordinateEvalMemberCM.getAssociatedMeasureGroup();
            if (mg != null) {
                return "[" + cubeName + "].[" + CdMdxUtils.escape((String)mg) + "]";
            }
            return null;
        }
        if (coordinateEvalMember instanceof OlapMeasureMember) {
            OlapMeasureMember coordinateEvalMemberM = (OlapMeasureMember)coordinateEvalMember;
            IOlapBuilderBaseFactsDef mg = coordinateEvalMemberM.getMeasureGroup();
            return "[" + cubeName + "].[" + CdMdxUtils.escape((String)mg.getMeasureGroupName()) + "]";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrillthroughIfNotContained(OlapInstrLocationRange definitionRange, IOlapSchemaPermission schemaPermissions, String name, @Nullable Long maxRows, List<OlapDrillthroughReturn> returns, @Nullable OlapEntityIdentifier target) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(definitionRange, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        String targetQN = null;
        if (target != null) {
            targetQN = this.normalizeTargetQN(definitionRange, target);
        }
        Map<String, OlapDrillthroughAction> map = this.actions;
        synchronized (map) {
            if (this.contains(name)) {
                throw new OlapEvaluationException(definitionRange, OlapErrorCode.DUPLICATED_ACTION, new Serializable[]{name});
            }
            this.actions.put(name, new OlapDrillthroughAction(name, maxRows, returns, targetQN));
        }
    }

    private String normalizeTargetQN(OlapInstrLocationRange definitionRange, OlapEntityIdentifier target) {
        if (target.getPartCount() > 2) {
            throw new OlapEvaluationException(definitionRange, OlapErrorCode.DRILLTHROUGH_ACTION_TARGET_NAME_ERROR, new Serializable[]{target.asMdxString()});
        }
        List<OlapRegularCube> cubes = this.schema.getCubes();
        int cubeCount = cubes.size();
        if (cubeCount > 1 && target.getPartCount() != 2) {
            throw new OlapEvaluationException(definitionRange, OlapErrorCode.DRILLTHROUGH_ACTION_TARGET_NAME_MISSING_CUBE, new Serializable[]{target.asMdxString()});
        }
        if (cubeCount == 0) {
            throw new OlapEvaluationException(definitionRange, OlapErrorCode.DRILLTHROUGH_ACTION_TARGET_NAME_NO_CUBE, new Serializable[]{target.asMdxString()});
        }
        String cubeName = target.getPartCount() == 2 ? target.getFirstPartAsName() : cubes.getFirst().getNameX();
        String measureGroupName = target.getLastPartAsName();
        return "[" + CdMdxUtils.escape((String)cubeName) + "].[" + CdMdxUtils.escape((String)measureGroupName) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDrillthroughAction remove(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, String name) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        Map<String, OlapDrillthroughAction> map = this.actions;
        synchronized (map) {
            return this.actions.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        if (schemaPermissions.isReadOnly()) {
            String schema = schemaPermissions.getSchema().getName();
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.SCHEMA_READ_ONLY, new Serializable[]{schema});
        }
        Map<String, OlapDrillthroughAction> map = this.actions;
        synchronized (map) {
            this.actions.clear();
        }
    }
}

