/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple.dimensionality;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.OlapIterable;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTupleDimensionalityHelper {
    public static boolean SINGLE_MEASURE_DIMENSIONALITY_OFF = false;

    public static void assertDimensionality(IOlapEvaluationExceptionContext context, OlapMember left, OlapMember right) {
        if (!OlapTupleDimensionalityHelper.hasSameDimensionality(left, right)) {
            OlapTupleDimensionalityHelper.onDimensionalityError(context, left, right);
        }
    }

    public static void assertDimensionality(IOlapEvaluationExceptionContext context, OlapTuple left, OlapTuple right) {
        if (left.getMemberCount() != right.getMemberCount()) {
            OlapTupleDimensionalityHelper.onDimensionalityError(context, left, right);
        }
        for (int idx = 0; idx < left.getMemberCount(); ++idx) {
            if (OlapTupleDimensionalityHelper.hasSameDimensionality(left.getMember(idx), right.getMember(idx))) continue;
            OlapTupleDimensionalityHelper.onDimensionalityError(context, left, right);
        }
    }

    public static void assertDimensionality(IOlapEvaluationExceptionContext context, List<OlapTuple> tuples) {
        int tsize = tuples.size();
        if (tsize <= 1) {
            return;
        }
        OlapTuple previous = tuples.get(0);
        for (int idx = 1; idx < tsize; ++idx) {
            OlapTuple current = tuples.get(idx);
            OlapTupleDimensionalityHelper.assertDimensionality(context, previous, current);
            previous = current;
        }
    }

    public static void assertExceptOrIntersectDimensionality(IOlapEvaluationExceptionContext context, OlapIterable<? extends OlapTuple> left, OlapIterable<? extends OlapTuple> right) {
        OlapTupleDimensionalityHelper.assertUnionDimensionality(context, Arrays.asList(left, right));
    }

    public static void assertUnionDimensionality(IOlapEvaluationExceptionContext context, List<? extends OlapIterable<? extends OlapTuple>> iterables) {
        ArrayList<OlapTuple> firstTuples = new ArrayList<OlapTuple>();
        for (OlapIterable<? extends OlapTuple> olapIterable : iterables) {
            OlapTupleDimensionalityHelper.addFirstTuple(firstTuples, olapIterable);
        }
        OlapTupleDimensionalityHelper.assertDimensionality(context, firstTuples);
    }

    public static void assertCrossjoinDimensionality(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, List<? extends OlapIterable<? extends OlapTuple>> iterables) {
        if (!context.isDimensionalityCheck()) {
            return;
        }
        ArrayList<OlapTuple> firstTuples = new ArrayList<OlapTuple>();
        for (OlapIterable<? extends OlapTuple> olapIterable : iterables) {
            OlapTupleDimensionalityHelper.addFirstTuple(firstTuples, olapIterable);
        }
        OlapTupleFactory.instance(context, cache, null, firstTuples.toArray(new OlapTuple[firstTuples.size()]));
    }

    private static void addFirstTuple(List<OlapTuple> firstTuples, OlapIterable<? extends OlapTuple> iterable) {
        OlapIterator<? extends OlapTuple> tuples = iterable.getIterator(false);
        tuples.reset();
        OlapTuple tuple = tuples.next();
        if (tuple != null) {
            firstTuples.add(tuple);
        }
    }

    private static boolean hasSameDimensionality(OlapMember left, OlapMember right) {
        OlapHierarchy leftH = left.getHierarchy();
        OlapHierarchy rightH = right.getHierarchy();
        return OlapTupleDimensionalityHelper.isSameHierarchyEx(leftH, rightH);
    }

    private static boolean isSameHierarchyEx(OlapHierarchy hierarchyL, OlapHierarchy hierarchyR) {
        if (SINGLE_MEASURE_DIMENSIONALITY_OFF) {
            return hierarchyL.equals(hierarchyR);
        }
        if (hierarchyL.isMeasures() && hierarchyR.isMeasures()) {
            return true;
        }
        return hierarchyL.equals(hierarchyR);
    }

    public static void onDimensionalityError(IOlapEvaluationExceptionContext context, IOlapTuple tuple) {
        OlapNameContext nameContext = context.getNameContext();
        String dimensionality = tuple.toDimensionalityString(nameContext);
        throw new OlapEvaluationException(context, OlapErrorCode.INVALID_TUPLE_DIMENSIONALITY, new Serializable[]{dimensionality, ""});
    }

    public static void onDimensionalityError(@Nullable IOlapEvaluationExceptionContext context, OlapTuple left, OlapTuple right) {
        GFContext gContext;
        OlapProperties props;
        boolean check;
        if (context == null) {
            throw new CdProgrammingException("Missing evaluation context!");
        }
        OlapNameContext nameContext = context.getNameContext();
        String leftDimensionality = left.toDimensionalityString(nameContext);
        String rightDimensionality = right.toDimensionalityString(nameContext);
        if (context instanceof GFContext && !(check = (props = (gContext = (GFContext)context).getRequestProperties()).isSetDimensionalityCheck())) {
            return;
        }
        throw new OlapEvaluationException(context, OlapErrorCode.INVALID_TUPLE_DIMENSIONALITY, new Serializable[]{leftDimensionality, rightDimensionality});
    }
}

