/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple.dimensionality;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTupleDimensionalityFactory {
    private static final OlapTupleDimensionality NULL_ENTITY = new OlapTupleDimensionality(OlapTupleDimensionality.Usage.DEGENERATED);
    private static final OlapTupleDimensionality BLANK_TUPLE = new OlapTupleDimensionality(OlapTupleDimensionality.Usage.DEGENERATED);
    private static final OlapTupleDimensionality INVALID_TUPLE = new OlapTupleDimensionality(OlapTupleDimensionality.Usage.DEGENERATED);
    private static final OlapTupleDimensionality FILTERED_OUT_TUPLE = new OlapTupleDimensionality(OlapTupleDimensionality.Usage.DEGENERATED);

    private OlapTupleDimensionalityFactory() {
    }

    public static OlapTupleDimensionality createForNullEntity() {
        return NULL_ENTITY;
    }

    public static OlapTupleDimensionality createForBlankTuple() {
        return BLANK_TUPLE;
    }

    public static OlapTupleDimensionality createForInvalidTuple() {
        return INVALID_TUPLE;
    }

    public static OlapTupleDimensionality createForFilteredOutTuple() {
        return FILTERED_OUT_TUPLE;
    }

    public static OlapTupleDimensionality createForHierarchy(int tupleDimensionalityIndex) {
        return new OlapTupleDimensionality(OlapTupleDimensionality.Usage.HIERARCHY, tupleDimensionalityIndex);
    }

    public static OlapTupleDimensionality create(OlapTupleDimensionalityCache cache, OlapBitSet hierarchies) {
        return cache.getOrCreate(hierarchies);
    }

    public static OlapTupleDimensionality create(@Nullable IOlapEvaluationExceptionContext errContext, OlapTupleDimensionalityCache cache, IOlapTuple tuple) {
        int count = tuple.getMemberCount();
        if (count == 0) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        return cache.getOrCreate(errContext, tuple);
    }

    @Nullable
    public static OlapTupleDimensionality createUnionEx(OlapTupleDimensionalityCache cache, @Nullable OlapTupleDimensionality dim1, @Nullable OlapTupleDimensionality dim2) {
        if (dim1 == null) {
            return dim2;
        }
        if (dim2 == null) {
            return dim1;
        }
        return cache.getOrCreateUnion(dim1, dim2);
    }

    public static OlapTupleDimensionality createBackdoor(OlapMember[] members) {
        OlapTupleDimensionality dimensionality = BLANK_TUPLE;
        for (OlapMember member : members) {
            dimensionality = dimensionality.union(member.getTupleDimensionality());
        }
        return dimensionality;
    }

    public static OlapTupleDimensionality createUnionEx(List<OlapTupleDimensionality> dimensionalities) {
        OlapBitSet newBitSet = new OlapBitSet();
        dimensionalities.forEach(dim -> newBitSet.or(dim.asBitSet()));
        return new OlapTupleDimensionality(OlapTupleDimensionality.Usage.OTHER, newBitSet);
    }
}

