/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple;

import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberRank;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import java.util.Comparator;

public abstract class OlapTupleHierarchizer {
    static final Comparator<TupleWithRank> POST_OFF = new Comparator<TupleWithRank>(){

        @Override
        public int compare(TupleWithRank o1, TupleWithRank o2) {
            return OlapTupleHierarchizer.comparePostOff(o1, o2);
        }
    };
    static final Comparator<TupleWithRank> POST_ON = new Comparator<TupleWithRank>(){

        @Override
        public int compare(TupleWithRank o1, TupleWithRank o2) {
            return OlapTupleHierarchizer.comparePostOn(o1, o2);
        }
    };

    public static int compareMembers(GFContext context, OlapMember member1, OlapMember member2) {
        OlapMember parent = member1.getParent();
        if (parent != null && OlapMember.equal(parent, member2.getParent())) {
            int pos2;
            int pos1 = parent.getChildPosition(null, member1);
            return pos1 < (pos2 = parent.getChildPosition(null, member2)) ? -1 : (pos1 == pos2 ? 0 : 1);
        }
        return OlapTupleHierarchizer.compareTuples(member1, member2);
    }

    public static int compareTuples(OlapTuple tuple1, OlapTuple tuple2) {
        return OlapTupleHierarchizer.comparePostOff(new TupleWithRank(tuple1), new TupleWithRank(tuple2));
    }

    private static int comparePostOff(TupleWithRank o1, TupleWithRank o2) {
        int size = o1.getMemberCount();
        for (int idx = 0; idx < size; ++idx) {
            OlapMemberRank rank2;
            OlapMemberRank rank1 = o1.getRank(idx);
            int cmp = rank1.compareTo(rank2 = o2.getRank(idx));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static int comparePostOn(TupleWithRank o1, TupleWithRank o2) {
        int size = o1.getMemberCount();
        for (int idx = 0; idx < size; ++idx) {
            OlapMemberRank rank2;
            OlapMember member2;
            OlapMember member1 = o1.getMember(idx);
            if (member1.isAncestor(member2 = o2.getMember(idx))) {
                return 1;
            }
            if (member2.isAncestor(member1)) {
                return -1;
            }
            OlapMemberRank rank1 = o1.getRank(idx);
            int cmp = rank1.compareTo(rank2 = o2.getRank(idx));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    static class TupleWithRank {
        OlapTuple tuple;
        OlapMemberRank[] ranks;

        public TupleWithRank(OlapTuple tuple) {
            this.tuple = tuple;
            if (tuple.getMemberCount() == 1) {
                this.ranks = new OlapMemberRank[]{tuple.getMember(0).getRank()};
            } else {
                this.ranks = new OlapMemberRank[tuple.getMemberCount()];
                for (int i = 0; i < this.ranks.length; ++i) {
                    this.ranks[i] = tuple.getMember(i).getRank();
                }
            }
        }

        public int getMemberCount() {
            return this.tuple.getMemberCount();
        }

        public OlapMember getMember(int idx) {
            return this.tuple.getMember(idx);
        }

        public OlapMemberRank getRank(int idx) {
            return this.ranks[idx];
        }
    }
}

