/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple;

import crazydev.common.collection.CdSingleItemList;
import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.model.IResTuple;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleHelper;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTuple
extends OlapNonScalarAbstractEntity
implements IOlapTuple,
IResTuple {
    public static final String FRIENDLY_NAME = "tuple";

    protected OlapTuple() {
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.TUPLE;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    public abstract OlapTuple[] unroll(GFContext var1);

    public static void setDimensionBitSet(IOlapTuple tuple, OlapBitSet tupleDim) {
        int membersCount = tuple.getMemberCount();
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = tuple.getMember(idx);
            tupleDim.set(member.getDimension().getDimensionalityIndex());
        }
    }

    public static boolean hasMemberWithDimension(IOlapTuple tuple, OlapBitSet tupleDim) {
        int membersCount = tuple.getMemberCount();
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = tuple.getMember(idx);
            if (!tupleDim.get(member.getDimension().getDimensionalityIndex())) continue;
            return true;
        }
        return false;
    }

    @Override
    public OlapTuple asReadOnly(OlapEvaluationContext context) {
        return this;
    }

    @Override
    public abstract OlapTupleDimensionality getTupleDimensionality();

    @Override
    public OlapTupleDimensionality getTupleDimensionalityHint() {
        return this.getTupleDimensionality();
    }

    @Override
    public boolean isOK() {
        return !this.isInvalid() && !this.isFilteredOut();
    }

    @Override
    public boolean isKO() {
        return !this.isOK();
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public abstract int getMemberCount();

    @Override
    public abstract OlapMember getMember(int var1);

    @Nullable
    public abstract OlapTuple getTuple(OlapEvaluationContext var1, OlapDimension var2);

    @Override
    public boolean hasMember(OlapDimension dimension) {
        int membersCount = this.getMemberCount();
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = this.getMember(idx);
            if (!member.getDimension().equals(dimension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract boolean hasMember(OlapHierarchy var1);

    public abstract boolean hasMember(OlapMember var1);

    @Nullable
    public abstract OlapTuple extract(IOlapEvaluationExceptionContext var1, OlapTupleDimensionalityCache var2, @Nullable OlapTupleFilter var3, Collection<OlapHierarchy> var4);

    @Nullable
    public abstract OlapTuple extractOthers(IOlapEvaluationExceptionContext var1, OlapTupleDimensionalityCache var2, OlapTupleFilter var3, Set<OlapHierarchy> var4);

    @Override
    @Nullable
    public abstract OlapMember getMember(OlapHierarchy var1);

    @Nullable
    public OlapMember getMember(OlapHierarchy hierarchy, int idx) {
        return this.getMember(hierarchy);
    }

    @Nullable
    public OlapNonScalarEntity getMembers(OlapHierarchy hierarchy) {
        return this.getMember(hierarchy);
    }

    public List<OlapMember> getMembersList(OlapHierarchy hierarchy) {
        OlapMember member = this.getMember(hierarchy);
        return member != null ? new CdSingleItemList((Object)member) : Collections.emptyList();
    }

    @Override
    public abstract int getMemberPos(OlapHierarchy var1);

    @Nullable
    public OlapMember getMemberAtLevel(OlapLevel level) {
        OlapMember member = this.getMember(level.getHierarchy());
        return member != null ? member.getAncestor(level) : null;
    }

    @Override
    @Nullable
    public abstract OlapMember getMeasureMember();

    public abstract OlapTuple replace(int var1, OlapMember var2);

    public abstract boolean exists(@Nullable OlapTupleFilter var1);

    public abstract List<OlapDimension> getDimensions();

    public abstract List<OlapHierarchy> getTupleHierarchies();

    public abstract boolean hasCalcMember();

    @Nullable
    public abstract OlapTuple removeCalcMembers(IOlapEvaluationExceptionContext var1, OlapTupleDimensionalityCache var2);

    public OlapTupleSet<? extends OlapTuple> drilldown(@Nullable OlapMemberFilter memberFilter, @Nullable OlapTupleFilter tupleFilter, int pos) {
        OlapMember child;
        ArrayList<OlapTuple> drilldown = new ArrayList<OlapTuple>();
        OlapMember member = this.getMember(pos);
        OlapIterator<OlapMember> children = member.getChildren(memberFilter);
        children.reset();
        while ((child = children.next()) != null) {
            OlapTuple drillDownedTuple = this.replace(pos, child);
            if (tupleFilter != null && !tupleFilter.isAccepting(drillDownedTuple)) continue;
            drilldown.add(drillDownedTuple);
        }
        return OlapSetFactory.instance(drilldown);
    }

    public abstract boolean contains(OlapTuple var1);

    @Override
    public boolean isMdxNull() {
        return false;
    }

    @Override
    protected OlapTupleSet<? extends OlapTuple> toSet_(IOlapPrepareContext context) {
        if (context.isConstrained()) {
            return (OlapTupleSet)context.onConstrainedViolation();
        }
        if (this.isKO() || !this.exists(context.getMemberTupleFilter())) {
            return OlapSetFactory.empty();
        }
        return OlapSetFactory.singleton(this);
    }

    @Override
    public boolean isToSetApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public OlapTuple toTuple(IOlapPrepareContext context) {
        return this;
    }

    @Override
    public boolean isToTupleApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member")
    public @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member") OlapMember toNullableMember(IOlapPrepareContext context) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public boolean isToMemberApplicable(IOlapPrepareContext context) {
        return false;
    }

    @Override
    public OlapScalarEntity toValue(GFContext context, GFTupleEvaluator evaluator) {
        if (context.isConstrained()) {
            return (OlapScalarEntity)context.onConstrainedViolation();
        }
        return evaluator.getValue(context, this, false);
    }

    @Override
    public boolean isToValueApplicable(GFContext context, GFTupleEvaluator evaluator) {
        return true;
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    @Override
    public String toDimensionalityString(OlapNameContext nameContext) {
        return OlapTupleHelper.toDimensionalityString(nameContext, this);
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public abstract String toString();

    public abstract OlapDimensionality createDimensionality();

    public abstract void addMembersInArray(OlapMember[] var1, int var2);

    @Override
    public void setDimensionBitSet(OlapBitSet tupleDim) {
        OlapTuple.setDimensionBitSet(this, tupleDim);
    }

    @Override
    public boolean hasMeasure() {
        int membersCount = this.getMemberCount();
        for (int idx = 0; idx < membersCount; ++idx) {
            if (!this.getMember(idx).isMeasure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAll() {
        int membersCount = this.getMemberCount();
        if (membersCount == 0) {
            return false;
        }
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = this.getMember(idx);
            if (member.isAll()) continue;
            return false;
        }
        return true;
    }

    public boolean existAllways() {
        int membersCount = this.getMemberCount();
        if (membersCount == 0) {
            return true;
        }
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = this.getMember(idx);
            if (member.existAllways()) continue;
            return false;
        }
        return true;
    }

    public abstract boolean inSubTuple(OlapTuple var1, @Nullable OlapBitSet var2);

    @Override
    public abstract boolean isMeasure();

    public abstract boolean isCalculated();

    @Override
    public abstract boolean isMeasureVector();

    public abstract int getMeasureVectorSize();

    public int countMatching(OlapBitSet dim) {
        int count = 0;
        int memberCount = this.getMemberCount();
        for (int i = 0; i < memberCount; ++i) {
            if (!dim.get(this.getMember(i).getDimension().getDimensionalityIndex())) continue;
            ++count;
        }
        return count;
    }

    public boolean isInTupleDim(OlapTuple tuple) {
        return this.getMemberCount() <= tuple.getMemberCount() && this.getTupleDimensionality().isIn(tuple.getTupleDimensionality());
    }

    @Override
    public String toStringForDebugger() {
        return this.toMdxString(OlapNameContext.DEFAULT_VALUES, true, 512);
    }

    public abstract void forEach(Consumer<OlapMember> var1, Predicate<OlapMember> var2);
}

