/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.tuple;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.cluster.shared.schema.S_FactMemberDefIndices;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMeasureVectorMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapTruncatedString;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.OlapTupleHelper;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.cache.statement.OlapStatementCacheManager;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.util.OlapExistHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapRegularTuple
extends OlapTuple {
    private final OlapMember[] members;
    private final OlapTupleDimensionality dimensionality;
    private int hash = -1;

    OlapRegularTuple(OlapMember[] members, OlapTupleDimensionality dimensionality) {
        this.members = members;
        if (this.members.length == 1) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        this.dimensionality = dimensionality;
    }

    OlapRegularTuple(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleDimensionality dimensionality, OlapMember ... members) {
        this.members = members;
        if (this.members.length == 1) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        this.dimensionality = dimensionality != null ? dimensionality : OlapTupleDimensionalityFactory.create(context, cache, this);
    }

    OlapRegularTuple(OlapTupleDimensionality dimensionality, OlapMember[] members) {
        this.members = members;
        this.dimensionality = dimensionality;
        if (this.members.length == 1) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (this.dimensionality == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    OlapRegularTuple(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, OlapMember ... members) {
        this.members = members;
        if (this.members.length == 1) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        this.dimensionality = OlapTupleDimensionalityFactory.create(context, cache, this);
    }

    OlapRegularTuple(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTuple tuple, List<OlapMember> emembers) {
        int tcount = tuple == null ? 0 : tuple.getMemberCount();
        int esize = emembers.size();
        this.members = new OlapMember[esize + tcount];
        for (int idx = 0; idx < esize; ++idx) {
            this.members[idx] = emembers.get(idx);
        }
        int pos = emembers.size();
        if (tuple != null) {
            for (int tidx = 0; tidx < tcount; ++tidx) {
                this.members[pos++] = tuple.getMember(tidx);
            }
        }
        if (this.members.length == 1) {
            throw new CdProgrammingException("Inconsistent single member tuple creation!");
        }
        this.dimensionality = OlapTupleDimensionalityFactory.create(context, cache, this);
    }

    OlapRegularTuple(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, OlapTuple[] tuples) {
        int size = 0;
        for (int idx = 0; idx < tuples.length; ++idx) {
            OlapTuple tuple = tuples[idx];
            size += tuple.getMemberCount();
        }
        this.members = new OlapMember[size];
        int pos = 0;
        for (int idx = 0; idx < tuples.length; ++idx) {
            OlapTuple tuple = tuples[idx];
            tuple.addMembersInArray(this.members, pos);
            pos += tuple.getMemberCount();
        }
        if (this.members.length == 1) {
            throw new CdProgrammingException("Inconsistent single member tuple creation!");
        }
        this.dimensionality = OlapTupleDimensionalityFactory.create(context, cache, this);
    }

    OlapRegularTuple(GFContext context, OlapMember[] members) {
        this((IOlapEvaluationExceptionContext)context, context.getTupleDimensionalityCache(), members);
    }

    @Override
    public OlapTuple[] unroll(GFContext context) {
        OlapMeasureVectorMember vector = null;
        for (int ii = 0; ii < this.members.length; ++ii) {
            OlapMember member = this.members[ii];
            if (!member.isMeasureVector()) continue;
            if (vector == null) {
                vector = (OlapMeasureVectorMember)member;
                continue;
            }
            throw new RuntimeException("internal error: inconsistent measures-vector processing [" + this.toString() + "]");
        }
        if (vector == null) {
            OlapTuple[] unrolled = new OlapTuple[]{this};
            return unrolled;
        }
        OlapTuple[] unrolled = new OlapTuple[vector.getMeasureVectorSize()];
        for (int ii = 0; ii < unrolled.length; ++ii) {
            unrolled[ii] = this.unroll(context, vector, ii);
        }
        return unrolled;
    }

    private OlapTuple unroll(GFContext context, OlapMeasureVectorMember vector, int pos) {
        OlapMember[] unrolled = new OlapMember[this.members.length];
        for (int ii = 0; ii < this.members.length; ++ii) {
            OlapMember member = this.members[ii];
            if (OlapMember.equal(member, vector)) {
                OlapMeasureMember measure = vector.getMeasure(pos);
                unrolled[ii] = measure;
                continue;
            }
            unrolled[ii] = member;
        }
        OlapTupleDimensionalityCache cache = context.getTupleDimensionalityCache();
        OlapTuple unrolledTuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, cache, unrolled);
        return unrolledTuple;
    }

    @Override
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.dimensionality;
    }

    @Override
    public int getMemberCount() {
        return this.members.length;
    }

    @Override
    public OlapMember getMember(int idx) {
        return this.members[idx];
    }

    @Override
    @Nullable
    public OlapTuple getTuple(OlapEvaluationContext context, OlapDimension dimension) {
        ArrayList<OlapMember> newMembers = null;
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!member.getDimension().equals(dimension)) continue;
            if (newMembers == null) {
                newMembers = new ArrayList<OlapMember>();
            }
            newMembers.add(member);
        }
        if (newMembers == null) {
            return null;
        }
        if (newMembers.size() == 1) {
            return (OlapTuple)newMembers.get(0);
        }
        OlapStatementCacheManager cacheManager = context.getStatementExecutionContext().getStatementCacheManager();
        OlapTupleDimensionalityCache cache = cacheManager.getTupleDimensionalityCache();
        return new OlapRegularTuple((IOlapEvaluationExceptionContext)context, cache, null, newMembers);
    }

    @Override
    public boolean hasMember(OlapHierarchy hierarchy) {
        return this.dimensionality.isIn(hierarchy);
    }

    @Override
    public boolean hasMember(OlapMember lookupMember) {
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!OlapMember.equal(member, lookupMember)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public OlapTuple extract(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleFilter tupleFilter, Collection<OlapHierarchy> hierarchies) {
        if (hierarchies.isEmpty()) {
            return this;
        }
        ArrayList<OlapMember> newMembers = new ArrayList<OlapMember>(hierarchies.size());
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!hierarchies.contains(member.getHierarchy())) continue;
            newMembers.add(member);
        }
        if (newMembers.size() == hierarchies.size()) {
            if (newMembers.size() == this.members.length) {
                return this;
            }
            if (newMembers.size() == 1) {
                return (OlapTuple)newMembers.get(0);
            }
            return OlapTupleFactory.instance(context, cache, tupleFilter, newMembers);
        }
        return null;
    }

    @Override
    @Nullable
    public OlapTuple extractOthers(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, OlapTupleFilter tupleFilter, Set<OlapHierarchy> hierarchies) {
        if (hierarchies.isEmpty()) {
            return this;
        }
        ArrayList<OlapMember> newMembers = new ArrayList<OlapMember>(hierarchies.size());
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (hierarchies.contains(member.getHierarchy())) continue;
            newMembers.add(member);
        }
        if (this.members.length == newMembers.size()) {
            return this;
        }
        return OlapTupleFactory.instance(context, cache, tupleFilter, newMembers);
    }

    @Override
    @Nullable
    public OlapMember getMember(OlapHierarchy hierarchy) {
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!member.getHierarchy().equals(hierarchy)) continue;
            return member;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember getMember(OlapHierarchy hierarchy, int pos) {
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!member.getHierarchy().equals(hierarchy) || pos-- != 0) continue;
            return member;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapNonScalarEntity getMembers(OlapHierarchy hierarchy) {
        List list = this.getMembersList(hierarchy);
        if (((ArrayList)list).isEmpty()) {
            return null;
        }
        if (((ArrayList)list).size() == 1) {
            return (OlapNonScalarEntity)((ArrayList)list).get(0);
        }
        return OlapSetFactory.instance(list);
    }

    @NotNull
    public ArrayList<OlapMember> getMembersList(OlapHierarchy hierarchy) {
        ArrayList<OlapMember> list = new ArrayList<OlapMember>(2);
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!member.getHierarchy().equals(hierarchy)) continue;
            list.add(member);
        }
        return list;
    }

    @Override
    public int getMemberPos(OlapHierarchy hierarchy) {
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!member.getHierarchy().equals(hierarchy)) continue;
            return idx;
        }
        return -1;
    }

    @Override
    @Nullable
    public OlapMember getMeasureMember() {
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!member.isMeasure()) continue;
            return member;
        }
        return null;
    }

    @Override
    public OlapRegularTuple replace(int pos, OlapMember member) {
        if (pos < 0 || pos >= this.members.length) {
            throw new CdProgrammingException("Inconsistent member pos [" + pos + "]!");
        }
        if (!this.members[pos].getHierarchy().equals(member.getHierarchy())) {
            throw new CdProgrammingException("Inconsistent member hierarchy [" + ONames.uname4Log(member.getHierarchy()) + "]!");
        }
        OlapMember[] xmembers = new OlapMember[this.members.length];
        System.arraycopy(this.members, 0, xmembers, 0, this.members.length);
        xmembers[pos] = member;
        return new OlapRegularTuple(xmembers, this.dimensionality);
    }

    @Override
    public boolean exists(@Nullable OlapTupleFilter filter) {
        if (filter != null && !filter.isAccepting(this)) {
            return false;
        }
        return OlapExistHelper.exists(this);
    }

    @Override
    public List<OlapDimension> getDimensions() {
        ArrayList<OlapDimension> dimensions = new ArrayList<OlapDimension>(this.members.length);
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            dimensions.add(member.getDimension());
        }
        return dimensions;
    }

    @Override
    public List<OlapHierarchy> getTupleHierarchies() {
        ArrayList<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>(this.members.length);
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            hierarchies.add(member.getHierarchy());
        }
        return hierarchies;
    }

    @Override
    public boolean hasCalcMember() {
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (!member.isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OlapTuple removeCalcMembers(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache) {
        if (!this.hasCalcMember()) {
            return this;
        }
        ArrayList<OlapMember> remainings = new ArrayList<OlapMember>();
        for (int idx = 0; idx < this.members.length; ++idx) {
            OlapMember member = this.members[idx];
            if (member.isCalculated()) continue;
            remainings.add(member);
        }
        return OlapTupleFactory.instance(context, cache, null, remainings);
    }

    @Override
    public boolean contains(OlapTuple tuple) {
        if (tuple instanceof OlapRegularTuple) {
            OlapRegularTuple xtuple = (OlapRegularTuple)tuple;
            if (this.members.length != xtuple.members.length) {
                return false;
            }
            for (int idx = 0; idx < this.members.length; ++idx) {
                OlapMember left = this.members[idx];
                OlapMember right = xtuple.members[idx];
                if (OlapMember.equal(left, right) || left.isAncestor(right)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IOlapTuple)) {
            return false;
        }
        IOlapTuple that = (IOlapTuple)o;
        return OlapTupleHelper.equals(this, that);
    }

    @Override
    public int hashCode() {
        if (this.hash == -1) {
            this.hash = OlapTupleHelper.hashCode(this);
        }
        return this.hash;
    }

    public static String toMdxString(IOlapMembers members, OlapNameContext nameContext, boolean truncate, int maxSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int idx = 0; idx < members.getMemberCount(); ++idx) {
            OlapMember member = members.getMember(idx);
            if (idx > 0) {
                sb.append(",");
            }
            String str = member.toMdxString(nameContext, truncate, maxSize);
            sb.append(str);
            if (maxSize == -1 || sb.length() <= maxSize) continue;
            if (!truncate) {
                throw new OlapTruncatedString();
            }
            return sb.substring(0, maxSize) + " ...";
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toMdxString(OlapMember[] members, OlapNameContext nameContext, boolean truncate, int maxSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int idx = 0; idx < members.length; ++idx) {
            OlapMember member = members[idx];
            if (idx > 0) {
                sb.append(",");
            }
            String str = member.toMdxString(nameContext, truncate, maxSize);
            sb.append(str);
            if (maxSize == -1 || sb.length() <= maxSize) continue;
            if (!truncate) {
                throw new OlapTruncatedString();
            }
            return sb.substring(0, maxSize) + " ...";
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toMdxString(List<OlapMember> members, OlapNameContext nameContext, boolean truncate, int maxSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int idx = 0; idx < members.size(); ++idx) {
            OlapMember member = members.get(idx);
            if (idx > 0) {
                sb.append(",");
            }
            String str = member.toMdxString(nameContext, truncate, maxSize);
            sb.append(str);
            if (maxSize == -1 || sb.length() <= maxSize) continue;
            if (!truncate) {
                throw new OlapTruncatedString();
            }
            return sb.substring(0, maxSize) + " ...";
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) {
        return OlapRegularTuple.toMdxString(this.members, nameContext, truncate, maxSize);
    }

    @Override
    public String toString() {
        return OlapTupleHelper.toString(this);
    }

    @Override
    public OlapDimensionality createDimensionality() {
        OlapDimensionality dimensionality = new OlapDimensionality();
        for (int i = 0; i < this.members.length; ++i) {
            dimensionality.add(this.members[i].getDimension());
        }
        return dimensionality;
    }

    @Override
    public void addMembersInArray(OlapMember[] array, int position) {
        System.arraycopy(this.members, 0, array, position, this.members.length);
    }

    @Override
    public boolean inSubTuple(OlapTuple lookup, @Nullable OlapBitSet bitSet) {
        int memberCount = this.getMemberCount();
        for (int i = 0; i < lookup.getMemberCount(); ++i) {
            OlapMember lookupMember = lookup.getMember(i);
            boolean found = false;
            int secondMember = bitSet == null ? 0 : (bitSet.get(lookupMember.getHierarchy().getTupleDimensionalityIndex()) ? 1 : 0);
            for (int j = 0; j < memberCount; ++j) {
                OlapMember member = this.getMember(j);
                if (lookupMember.getHierarchy() != member.getHierarchy()) continue;
                if (secondMember != 0) {
                    --secondMember;
                    continue;
                }
                if (!OlapMember.equal(lookupMember, member)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMeasure() {
        for (int ii = 0; ii < this.members.length; ++ii) {
            OlapMember member = this.members[ii];
            if (!member.isMeasure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCalculated() {
        for (int ii = 0; ii < this.members.length; ++ii) {
            OlapMember member = this.members[ii];
            if (!member.isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMeasureVector() {
        for (int ii = 0; ii < this.members.length; ++ii) {
            if (!this.members[ii].isMeasureVector()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMeasureVectorSize() {
        for (int ii = 0; ii < this.members.length; ++ii) {
            if (!this.members[ii].isMeasureVector()) continue;
            return this.members[ii].getMeasureVectorSize();
        }
        return -1;
    }

    @Override
    public void forEach(Consumer<OlapMember> consumer, Predicate<OlapMember> filter) {
        for (int i = 0; i < this.members.length; ++i) {
            OlapMember member = this.members[i];
            if (!filter.test(member)) continue;
            consumer.accept(member);
        }
    }

    @Override
    @Nullable
    public OlapMember getMemberByDimensionality(int tupleDimensionality) {
        for (int i = 0; i < this.members.length; ++i) {
            OlapMember member = this.members[i];
            if (member.getHierarchy().getTupleDimensionalityIndex() != tupleDimensionality) continue;
            return member;
        }
        return null;
    }

    @Override
    public S_TupleDimensionality getClusterTupleDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void forEach(S_FactMemberDefIndices indices) {
        OlapRegularTuple.forEach(this.members, indices);
    }

    public static void forEach(OlapMember[] members, S_FactMemberDefIndices indices) {
        for (int ii = 0; ii < members.length; ++ii) {
            OlapMember member = members[ii];
            member.forEach(indices);
        }
    }
}

