/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.subcube;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapTruncatedString;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeOperationKind;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapSubCubeSymDifferenceEntity
extends OlapSubCubeEntity {
    public static final String FRIENDLY_NAME = "SubCubeMinus";

    public OlapSubCubeSymDifferenceEntity(List<OlapNonScalarEntity> args) {
        super(args);
    }

    @Override
    public OlapSubCubeOperationKind getOperation() {
        return OlapSubCubeOperationKind.SYM_DIFFERENCE;
    }

    @Override
    public S_FactSubCube asClusterCube(@Nullable OlapAbstractCategoryMember category) {
        List<OlapNonScalarEntity> entities = this.getEntities(null);
        int size = entities.size();
        if (size > 2) {
            throw new CdShouldNotBeHereProgrammingException("" + size);
        }
        S_FactSubCube sucu = new S_FactSubCube(S_FactSubCube.Operation.AND);
        if (size == 0) {
            return sucu;
        }
        if (size == 1) {
            OlapSubCubeSymDifferenceEntity.add(sucu, entities.get(0));
            return sucu;
        }
        OlapNonScalarEntity a = entities.get(0);
        OlapNonScalarEntity b = entities.get(1);
        S_FactSubCube sucuOr = new S_FactSubCube(S_FactSubCube.Operation.OR);
        OlapSubCubeSymDifferenceEntity.add(sucuOr, a);
        OlapSubCubeSymDifferenceEntity.add(sucuOr, b);
        S_FactSubCube sucuAndNot = new S_FactSubCube(S_FactSubCube.Operation.NOT);
        S_FactSubCube sucuAnd = new S_FactSubCube(S_FactSubCube.Operation.AND);
        OlapSubCubeSymDifferenceEntity.add(sucuAnd, a);
        OlapSubCubeSymDifferenceEntity.add(sucuAnd, b);
        sucuAndNot.addSubCube(sucuAnd);
        sucu.addSubCube(sucuOr);
        sucu.addSubCube(sucuAndNot);
        return sucu;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) throws OlapTruncatedString {
        return "SubCubeMinus()";
    }
}

